/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.group.impl;

import com.pi4j.io.OnOff;
import com.pi4j.io.exception.IOException;
import com.pi4j.io.group.OnOffGroup;
import com.pi4j.io.group.impl.GroupBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOnOffGroup
extends GroupBase<OnOffGroup, OnOff>
implements OnOffGroup {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected boolean state = false;

    public DefaultOnOffGroup(OnOff ... member) {
        super(new OnOff[0]);
        this.add(member);
    }

    @Override
    public boolean isOn() {
        return this.state;
    }

    @Override
    public OnOffGroup on() throws IOException {
        this.state = true;
        this.sync(this.state);
        return this;
    }

    @Override
    public OnOffGroup off() throws IOException {
        this.state = false;
        this.sync(this.state);
        return this;
    }

    private void sync(boolean state) throws IOException {
        this.members.forEach(m4 -> {
            try {
                if (state) {
                    m4.on();
                } else {
                    m4.off();
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), e);
            }
        });
    }
}

