/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.gpiod.internal;

import com.pi4j.library.gpiod.internal.GpioChip;
import com.pi4j.library.gpiod.internal.GpioDException;
import com.pi4j.library.gpiod.internal.LineActiveState;
import com.pi4j.library.gpiod.internal.LineBias;
import com.pi4j.library.gpiod.internal.LineDirection;
import com.pi4j.library.gpiod.internal.LineEvent;
import com.pi4j.library.gpiod.internal.LineRequest;
import com.pi4j.library.gpiod.util.NativeLibraryLoader;

public class GpioD {
    private GpioD() {
    }

    static GpioChip chipOpen(String path) {
        Long ptr = GpioD.c_gpiod_chip_open(path);
        if (ptr == null) {
            throw new GpioDException("c_gpiod_chip_open failed! (" + GpioD.c_gpiod_strerror() + ")");
        }
        return new GpioChip(ptr);
    }

    private static native Long c_gpiod_chip_open(String var0);

    static void chipClose(long chipPtr) {
        GpioD.c_gpiod_chip_close(chipPtr);
    }

    private static native void c_gpiod_chip_close(long var0);

    static String chipGetName(long chipPtr) {
        return GpioD.c_gpiod_chip_name(chipPtr);
    }

    private static native String c_gpiod_chip_name(long var0);

    static String chipGetLabel(long chipPtr) {
        return GpioD.c_gpiod_chip_label(chipPtr);
    }

    private static native String c_gpiod_chip_label(long var0);

    static int chipGetNumLines(long chipPtr) {
        return GpioD.c_gpiod_chip_num_lines(chipPtr);
    }

    private static native int c_gpiod_chip_num_lines(long var0);

    static long chipGetLine(long chipPtr, int offset) {
        Long linePtr = GpioD.c_gpiod_chip_get_line(chipPtr, offset);
        if (linePtr == null) {
            throw new GpioDException("c_gpiod_chip_get_line failed! (" + GpioD.c_gpiod_strerror() + ")");
        }
        return linePtr;
    }

    private static native Long c_gpiod_chip_get_line(long var0, int var2);

    static long chipGetLine(long chipPtr, String name) {
        Long linePtr = GpioD.c_gpiod_chip_find_line(chipPtr, name);
        if (linePtr == null) {
            throw new GpioDException("c_gpiod_chip_find_line failed! (" + GpioD.c_gpiod_strerror() + ")");
        }
        return linePtr;
    }

    private static native Long c_gpiod_chip_find_line(long var0, String var2);

    static int lineGetOffset(long linePtr) {
        return GpioD.c_gpiod_line_offset(linePtr);
    }

    private static native int c_gpiod_line_offset(long var0);

    static String lineGetName(long linePtr) {
        return GpioD.c_gpiod_line_name(linePtr);
    }

    private static native String c_gpiod_line_name(long var0);

    static String lineGetConsumer(long linePtr) {
        return GpioD.gpiod_line_consumer(linePtr);
    }

    private static native String gpiod_line_consumer(long var0);

    static LineDirection lineGetDirection(long linePtr) {
        return LineDirection.fromInt(GpioD.c_gpiod_line_direction(linePtr));
    }

    private static native int c_gpiod_line_direction(long var0);

    static LineActiveState lineGetActiveState(long linePtr) {
        return LineActiveState.fromInt(GpioD.c_gpiod_line_active_state(linePtr));
    }

    private static native int c_gpiod_line_active_state(long var0);

    static LineBias lineGetBias(long linePtr) {
        return LineBias.fromInt(GpioD.c_gpiod_line_bias(linePtr));
    }

    private static native int c_gpiod_line_bias(long var0);

    static boolean lineIsUsed(long linePtr) {
        return GpioD.c_gpiod_line_is_used(linePtr);
    }

    private static native boolean c_gpiod_line_is_used(long var0);

    static boolean lineIsOpenDrain(long linePtr) {
        return GpioD.c_gpiod_line_is_open_drain(linePtr);
    }

    private static native boolean c_gpiod_line_is_open_drain(long var0);

    static boolean lineIsOpenSource(long linePtr) {
        return GpioD.c_gpiod_line_is_open_source(linePtr);
    }

    private static native boolean c_gpiod_line_is_open_source(long var0);

    static void lineUpdate(long linePtr) {
        int result = GpioD.c_gpiod_line_update(linePtr);
        if (result < 0) {
            throw new GpioDException("c_gpiod_line_update failed: " + result + " (" + GpioD.c_gpiod_strerror() + ")");
        }
    }

    private static native int c_gpiod_line_update(long var0);

    static void lineRequest(long linePtr, long lineRequestPtr, int defaultVal) {
        int result = GpioD.c_gpiod_line_request(linePtr, lineRequestPtr, defaultVal);
        if (result < 0) {
            throw new GpioDException("c_gpiod_line_request failed: " + result + " (" + GpioD.c_gpiod_strerror() + ")");
        }
    }

    private static native int c_gpiod_line_request(long var0, long var2, int var4);

    static void lineRequestInput(long linePtr, String consumer) {
        int result = GpioD.c_gpiod_line_request_input(linePtr, consumer);
        if (result < 0) {
            throw new GpioDException("c_gpiod_line_request_input failed: " + result + " (" + GpioD.c_gpiod_strerror() + ")");
        }
    }

    private static native int c_gpiod_line_request_input(long var0, String var2);

    static void lineRequestOutput(long linePtr, String consumer, int defaultVal) {
        int result = GpioD.c_gpiod_line_request_output(linePtr, consumer, defaultVal);
        if (result < 0) {
            throw new GpioDException("c_gpiod_line_request_output failed: " + result + " (" + GpioD.c_gpiod_strerror() + ")");
        }
    }

    private static native int c_gpiod_line_request_output(long var0, String var2, int var3);

    static void lineRequestRisingEdgeEvents(long linePtr, String consumer) {
        int result = GpioD.c_gpiod_line_request_rising_edge_events(linePtr, consumer);
        if (result < 0) {
            throw new GpioDException("c_gpiod_line_request_rising_edge_events failed: " + result + " (" + GpioD.c_gpiod_strerror() + ")");
        }
    }

    private static native int c_gpiod_line_request_rising_edge_events(long var0, String var2);

    static void lineRequestFallingEdgeEvents(long linePtr, String consumer) {
        int result = GpioD.c_gpiod_line_request_falling_edge_events(linePtr, consumer);
        if (result < 0) {
            throw new GpioDException("c_gpiod_line_request_falling_edge_events failed: " + result + " (" + GpioD.c_gpiod_strerror() + ")");
        }
    }

    private static native int c_gpiod_line_request_falling_edge_events(long var0, String var2);

    static void lineRequestBothEdgeEvents(long linePtr, String consumer) {
        int result = GpioD.c_gpiod_line_request_both_edges_events(linePtr, consumer);
        if (result < 0) {
            throw new GpioDException("c_gpiod_line_request_both_edges_events failed: " + result + " (" + GpioD.c_gpiod_strerror() + ")");
        }
    }

    private static native int c_gpiod_line_request_both_edges_events(long var0, String var2);

    static void lineRequestInputFlags(long linePtr, String consumer, int flags) {
        int result = GpioD.c_gpiod_line_request_input_flags(linePtr, consumer, flags);
        if (result < 0) {
            throw new GpioDException("c_gpiod_line_request_input_flags failed: " + result + " (" + GpioD.c_gpiod_strerror() + ")");
        }
    }

    private static native int c_gpiod_line_request_input_flags(long var0, String var2, int var3);

    static void lineRequestOutputFlags(long linePtr, String consumer, int flags, int defaultVal) {
        int result = GpioD.c_gpiod_line_request_output_flags(linePtr, consumer, flags, defaultVal);
        if (result < 0) {
            throw new GpioDException("c_gpiod_line_request_output_flags failed: " + result + " (" + GpioD.c_gpiod_strerror() + ")");
        }
    }

    private static native int c_gpiod_line_request_output_flags(long var0, String var2, int var3, int var4);

    static void lineRequestRisingEdgeEventsFlags(long linePtr, String consumer, int flags) {
        int result = GpioD.c_gpiod_line_request_rising_edge_events_flags(linePtr, consumer, flags);
        if (result < 0) {
            throw new GpioDException("c_gpiod_line_request_rising_edge_events_flags failed: " + result + " (" + GpioD.c_gpiod_strerror() + ")");
        }
    }

    private static native int c_gpiod_line_request_rising_edge_events_flags(long var0, String var2, int var3);

    static void lineRequestFallingEdgeEventsFlags(long linePtr, String consumer, int flags) {
        int result = GpioD.c_gpiod_line_request_falling_edge_events_flags(linePtr, consumer, flags);
        if (result < 0) {
            throw new GpioDException("c_gpiod_line_request_falling_edge_events_flags failed: " + result + " (" + GpioD.c_gpiod_strerror() + ")");
        }
    }

    private static native int c_gpiod_line_request_falling_edge_events_flags(long var0, String var2, int var3);

    static void lineRequestBothEdgeEventsFlags(long linePtr, String consumer, int flags) {
        int result = GpioD.c_gpiod_line_request_both_edges_events_flags(linePtr, consumer, flags);
        if (result < 0) {
            throw new GpioDException("c_gpiod_line_request_both_edges_events_flags failed: " + result + " (" + GpioD.c_gpiod_strerror() + ")");
        }
    }

    private static native int c_gpiod_line_request_both_edges_events_flags(long var0, String var2, int var3);

    static void lineRelease(long linePtr) {
        GpioD.c_gpiod_line_release(linePtr);
    }

    private static native void c_gpiod_line_release(long var0);

    static boolean lineIsRequested(long linePtr) {
        return GpioD.c_gpiod_line_is_requested(linePtr);
    }

    private static native boolean c_gpiod_line_is_requested(long var0);

    static boolean lineIsFree(long linePtr) {
        return GpioD.c_gpiod_line_is_free(linePtr);
    }

    private static native boolean c_gpiod_line_is_free(long var0);

    static int lineGetValue(long linePtr) {
        int result = GpioD.c_gpiod_line_get_value(linePtr);
        if (result < 0) {
            throw new GpioDException("c_gpiod_line_get_value failed: " + result + " (" + GpioD.c_gpiod_strerror() + ")");
        }
        return result;
    }

    private static native int c_gpiod_line_get_value(long var0);

    static void lineSetValue(long linePtr, int value) {
        int result = GpioD.c_gpiod_line_set_value(linePtr, value);
        if (result < 0) {
            throw new GpioDException("c_gpiod_line_set_value failed: " + result + " (" + GpioD.c_gpiod_strerror() + ")");
        }
    }

    private static native int c_gpiod_line_set_value(long var0, int var2);

    static void lineSetConfig(long linePtr, LineRequest direction, int flags, int value) {
        int result = GpioD.c_gpiod_line_set_config(linePtr, direction.val, flags, value);
        if (result < 0) {
            throw new GpioDException("c_gpiod_line_set_config failed: " + result + " (" + GpioD.c_gpiod_strerror() + ")");
        }
    }

    private static native int c_gpiod_line_set_config(long var0, int var2, int var3, int var4);

    static void lineSetFlags(long linePtr, int flags) {
        int result = GpioD.c_gpiod_line_set_flags(linePtr, flags);
        if (result < 0) {
            throw new GpioDException("c_gpiod_line_set_flags failed: " + result + " (" + GpioD.c_gpiod_strerror() + ")");
        }
    }

    private static native int c_gpiod_line_set_flags(long var0, int var2);

    static void lineSetDirectionInput(long linePtr) {
        int result = GpioD.c_gpiod_line_set_direction_input(linePtr);
        if (result < 0) {
            throw new GpioDException("c_gpiod_line_set_direction_input failed: " + result + " (" + GpioD.c_gpiod_strerror() + ")");
        }
    }

    private static native int c_gpiod_line_set_direction_input(long var0);

    static void lineSetDirectionOutput(long linePtr, int value) {
        int result = GpioD.c_gpiod_line_set_direction_output(linePtr, value);
        if (result < 0) {
            throw new GpioDException("c_gpiod_line_set_direction_output failed: " + result + " (" + GpioD.c_gpiod_strerror() + ")");
        }
    }

    private static native int c_gpiod_line_set_direction_output(long var0, int var2);

    static boolean lineEventWait(long linePtr, long timeoutNs) {
        int result = GpioD.c_gpiod_line_event_wait(linePtr, timeoutNs);
        if (result < 0) {
            throw new GpioDException("c_gpiod_line_event_wait failed: " + result + " (" + GpioD.c_gpiod_strerror() + ")");
        }
        return result > 0;
    }

    private static native int c_gpiod_line_event_wait(long var0, long var2);

    static boolean lineEventRead(long linePtr, long lineEventPtr) {
        int result = GpioD.c_gpiod_line_event_read(linePtr, lineEventPtr);
        if (result < 0) {
            throw new GpioDException("c_gpiod_line_event_read failed: " + result + " (" + GpioD.c_gpiod_strerror() + ")");
        }
        return result > 0;
    }

    private static native int c_gpiod_line_event_read(long var0, long var2);

    static long lineGet(String device, int offset) {
        Long ptr = GpioD.c_gpiod_line_get(device, offset);
        if (ptr == null) {
            throw new GpioDException("c_gpiod_line_get failed! (" + GpioD.c_gpiod_strerror() + ")");
        }
        return ptr;
    }

    private static native Long c_gpiod_line_get(String var0, int var1);

    static long lineFind(String name) {
        Long ptr = GpioD.gpiod_line_find(name);
        if (ptr == null) {
            throw new GpioDException("gpiod_line_find failed! (" + GpioD.c_gpiod_strerror() + ")");
        }
        return ptr;
    }

    private static native Long gpiod_line_find(String var0);

    static void lineCloseChip(long linePtr) {
        GpioD.c_gpiod_line_close_chip(linePtr);
    }

    private static native void c_gpiod_line_close_chip(long var0);

    static long lineGetChip(long linePtr) {
        return GpioD.gpiod_line_get_chip(linePtr);
    }

    private static native long gpiod_line_get_chip(long var0);

    static long chipIterNew() {
        Long ptr = GpioD.gpiod_chip_iter_new();
        if (ptr == null) {
            throw new GpioDException("gpiod_chip_iter_new failed! (" + GpioD.c_gpiod_strerror() + ")");
        }
        return ptr;
    }

    private static native Long gpiod_chip_iter_new();

    static void chipIterFree(long chipIterPtr) {
        GpioD.c_gpiod_chip_iter_free(chipIterPtr);
    }

    private static native void c_gpiod_chip_iter_free(long var0);

    static void chipIterFreeNoClose(long chipIterPtr) {
        GpioD.c_gpiod_chip_iter_free_noclose(chipIterPtr);
    }

    private static native void c_gpiod_chip_iter_free_noclose(long var0);

    private static native Long c_gpiod_chip_iter_next(long var0);

    static Long chipIterNextNoClose(long chipIterPtr) {
        return GpioD.c_gpiod_chip_iter_next_noclose(chipIterPtr);
    }

    private static native Long c_gpiod_chip_iter_next_noclose(long var0);

    static long lineEventGetTimespec(long lineEventPtr) {
        return GpioD.c_gpiod_line_event_get_timespec(lineEventPtr);
    }

    private static native long c_gpiod_line_event_get_timespec(long var0);

    static LineEvent lineEventGetType(long lineEventPtr) {
        return LineEvent.fromInt(GpioD.c_gpiod_line_event_get_type(lineEventPtr));
    }

    private static native int c_gpiod_line_event_get_type(long var0);

    static long lineEventNew() {
        Long ptr = GpioD.c_gpiod_line_event_new();
        if (ptr == null) {
            throw new GpioDException("c_gpiod_line_event_new failed! (" + GpioD.c_gpiod_strerror() + ")");
        }
        return ptr;
    }

    private static native Long c_gpiod_line_event_new();

    static void lineEventFree(long eventPtr) {
        GpioD.c_gpiod_line_event_free(eventPtr);
    }

    private static native void c_gpiod_line_event_free(long var0);

    static String getVersion() {
        return GpioD.c_gpiod_version_string();
    }

    private static native String c_gpiod_version_string();

    private static native String c_gpiod_strerror();

    static {
        NativeLibraryLoader.load("libgpiod.so", "pi4j-gpiod");
        NativeLibraryLoader.load("libpi4j-gpiod.so", "pi4j-gpiod");
    }
}

