/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.gpiod.internal;

import com.pi4j.boardinfo.definition.BoardModel;
import com.pi4j.boardinfo.util.BoardInfoHelper;
import com.pi4j.library.gpiod.internal.GpioChip;
import com.pi4j.library.gpiod.internal.GpioD;
import com.pi4j.library.gpiod.internal.GpioLine;
import com.pi4j.library.gpiod.internal.GpioLineEvent;
import java.io.Closeable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GpioDContext
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(GpioDContext.class);
    private static final GpioDContext instance = new GpioDContext();
    private GpioChip gpioChip;
    private final Map<Integer, GpioLine> openLines = new HashMap<Integer, GpioLine>();
    private final Set<Long> openLineEvents = new HashSet<Long>();

    public static GpioDContext getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initialize() {
        if (BoardInfoHelper.current().getBoardModel() == BoardModel.UNKNOWN) {
            logger.warn("Can't initialize GpioD context, board model is unknown");
            return;
        }
        if (this.gpioChip != null) {
            return;
        }
        long chipIterPtr = GpioD.chipIterNew();
        GpioChip found = null;
        try {
            Long chipPtr;
            while ((chipPtr = GpioD.chipIterNextNoClose(chipIterPtr)) != null) {
                GpioChip chip = new GpioChip(chipPtr);
                if (!chip.getLabel().contains("pinctrl")) {
                    GpioD.chipClose(chip.getCPointer());
                    continue;
                }
                found = chip;
                break;
            }
        }
        finally {
            if (found != null) {
                GpioD.chipIterFreeNoClose(chipIterPtr);
            } else {
                GpioD.chipIterFree(chipIterPtr);
            }
        }
        if (found == null) {
            throw new IllegalStateException("Couldn't identify gpiochip!");
        }
        this.gpioChip = found;
        logger.info("Using chip " + this.gpioChip.getName() + " " + this.gpioChip.getLabel());
    }

    public synchronized GpioLine getOrOpenLine(int offset) {
        if (this.gpioChip == null) {
            throw new IllegalStateException("No gpio chip yet initialized!");
        }
        return this.openLines.computeIfAbsent(offset, o -> {
            long chipLinePtr = GpioD.chipGetLine(this.gpioChip.getCPointer(), offset);
            return new GpioLine((int)o, chipLinePtr);
        });
    }

    public synchronized void closeLine(GpioLine gpioLine) {
        long linePtr = gpioLine.getCPointer();
        GpioD.lineRelease(linePtr);
    }

    public synchronized GpioLineEvent openLineEvent() {
        long lineEventPtr = GpioD.lineEventNew();
        this.openLineEvents.add(lineEventPtr);
        return new GpioLineEvent(lineEventPtr);
    }

    public synchronized void closeLineEvent(GpioLineEvent ... lineEvents) {
        for (GpioLineEvent lineEvent : lineEvents) {
            GpioD.lineEventFree(lineEvent.getCPointer());
            this.openLineEvents.remove(lineEvent.getCPointer());
        }
    }

    @Override
    public synchronized void close() {
        if (this.gpioChip == null) {
            return;
        }
        for (Long openLineEvent : this.openLineEvents) {
            GpioD.lineEventFree(openLineEvent);
        }
        this.openLineEvents.clear();
        Iterator<Number> iterator = new HashSet<Integer>(this.openLines.keySet()).iterator();
        while (iterator.hasNext()) {
            int address = (Integer)iterator.next();
            GpioLine line = this.openLines.remove(address);
            GpioD.lineRelease(line.getCPointer());
        }
        this.openLines.clear();
        if (this.gpioChip != null) {
            GpioD.chipClose(this.gpioChip.getCPointer());
        }
        this.gpioChip = null;
    }
}

