/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.gpiod.util;

import com.pi4j.boardinfo.definition.BoardModel;
import com.pi4j.boardinfo.util.BoardInfoHelper;
import com.pi4j.library.gpiod.util.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLibraryLoader {
    private static final Set<String> loadedLibraries = new TreeSet<String>();
    protected static final Logger logger = LoggerFactory.getLogger(NativeLibraryLoader.class);
    private static boolean initialized;

    private NativeLibraryLoader() {
    }

    public static synchronized void load(String fileName, String libName) {
        String osArch;
        if (!initialized) {
            initialized = true;
        }
        if (loadedLibraries.contains(fileName)) {
            logger.warn("Library [" + fileName + "] has already been loaded; no need to load again.");
            return;
        }
        loadedLibraries.add(fileName);
        String libpath = System.getProperty("pi4j.library.path");
        if (StringUtil.isNotNullOrEmpty(libpath, true)) {
            if (libpath.equalsIgnoreCase("system")) {
                logger.debug("Attempting to load library using {pi4j.library.path} system resolved library name: [" + libName + "]");
                try {
                    System.loadLibrary(libName);
                }
                catch (Exception ex) {
                    throw new UnsatisfiedLinkError("Pi4J was unable load the native library [" + libName + "] from the system defined library path.  The system property 'pi4j.library.path' is defined as [" + libpath + "]. You can alternatively define the 'pi4j.library.path' system property to override this behavior and specify an absolute library path.; UNDERLYING EXCEPTION: [" + ex.getClass().getName() + "]=" + ex.getMessage());
                }
            }
            if (libpath.equalsIgnoreCase("local")) {
                try {
                    libpath = NativeLibraryLoader.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
                }
                catch (URISyntaxException e) {
                    logger.error(e.getMessage(), e);
                    libpath = ".";
                }
                String path = Paths.get(libpath, fileName).toString();
                logger.debug("Attempting to load library using {pi4j.library.path} defined path: [" + path + "]");
                try {
                    System.load(path);
                }
                catch (Exception ex) {
                    throw new UnsatisfiedLinkError("Pi4J was unable load the native library [" + libName + "] from the user defined library path.  The system property 'pi4j.library.path' is defined as [" + libpath + "]. Please make sure the defined the 'pi4j.library.path' system property contains the correct absolute library path.; UNDERLYING EXCEPTION: [" + ex.getClass().getName() + "]=" + ex.getMessage());
                }
            }
            String path = Paths.get(libpath, fileName).toString();
            logger.debug("Attempting to load library using {pi4j.library.path} defined path: [" + path + "]");
            try {
                System.load(path);
            }
            catch (UnsatisfiedLinkError ex) {
                String exceptMessage = ex.getMessage().contains("wrong ELF class") ? "Pi4J was unable to link the native library [" + path + "] embedded  inside this JAR [" + NativeLibraryLoader.class.getProtectionDomain().getCodeSource().getLocation().getPath() + "].  The exception indicates a mismatch of architecture. armhf/ELFCLASS32 aarch64/ELFCLASS64 \n UNDERLYING EXCEPTION: [" + ex.getClass().getName() + "]=" + ex.getMessage() : "Pi4J was unable to extract and load the native library [" + path + "] from the embedded resources inside this JAR [" + NativeLibraryLoader.class.getProtectionDomain().getCodeSource().getLocation().getPath() + "]. to a temporary location on this system.  You can alternatively define the 'pi4j.library.path' system property to override this behavior and specify the library path.\n UNDERLYING EXCEPTION: [" + ex.getClass().getName() + "]=" + ex.getMessage();
                throw new UnsatisfiedLinkError(exceptMessage);
            }
            catch (Exception ex) {
                throw new UnsatisfiedLinkError("Pi4J was unable to extract and load the native library [" + path + "] from the embedded resources inside this JAR [" + NativeLibraryLoader.class.getProtectionDomain().getCodeSource().getLocation().getPath() + "]. to a temporary location on this system.  You can alternatively define the 'pi4j.library.path' system property to override this behavior and specify the library path.\n UNDERLYING EXCEPTION: [" + ex.getClass().getName() + "]=" + ex.getMessage());
            }
        }
        switch (osArch = System.getProperty("os.arch").toLowerCase()) {
            case "arm": {
                osArch = "armhf";
                break;
            }
            case "arm64": {
                osArch = "aarch64";
                break;
            }
            case "aarch64": {
                break;
            }
            default: {
                throw new IllegalStateException("Pi4J has detected and UNKNOWN/UNSUPPORTED 'os.arch' : [" + osArch + "]; only 'arm|armhf' and 'arm64|aarch64' are supported.");
            }
        }
        String path = "/lib/" + osArch + "/" + libName + "/" + fileName;
        logger.debug("Attempting to load library [" + fileName + "] using path: [" + path + "]");
        try {
            NativeLibraryLoader.loadLibraryFromClasspath(path);
            logger.debug("Library [" + fileName + "] loaded successfully using embedded resource file: [" + path + "]");
        }
        catch (UnsatisfiedLinkError e) {
            logger.error("Unable to load [" + fileName + "] using path: [" + path + "]", e);
            String exceptMessage = e.getMessage().contains("wrong ELF class") ? "Pi4J was unable to link the native library [" + path + "] embedded  inside this JAR [" + NativeLibraryLoader.class.getProtectionDomain().getCodeSource().getLocation().getPath() + "].  The exception indicates a mismatch of architecture. armhf/ELFCLASS32 aarch64/ELFCLASS64 \n All native libraries must be of architecture " + osArch + " \n UNDERLYING EXCEPTION: [" + e.getClass().getName() + "]=" + e.getMessage() : "Pi4J was unable to extract and load the native library [" + path + "] from the embedded resources inside this JAR [" + NativeLibraryLoader.class.getProtectionDomain().getCodeSource().getLocation().getPath() + "]. to a temporary location on this system.  You can alternatively define the 'pi4j.library.path' system property to override this behavior and specify the library path.\n UNDERLYING EXCEPTION: [" + e.getClass().getName() + "]=" + e.getMessage();
            throw new UnsatisfiedLinkError(exceptMessage);
        }
        catch (Exception e) {
            logger.error("Unable to load [" + fileName + "] using path: [" + path + "]", e);
            throw new UnsatisfiedLinkError("Pi4J was unable to extract and load the native library [" + path + "] from the embedded resources inside this JAR [" + NativeLibraryLoader.class.getProtectionDomain().getCodeSource().getLocation().getPath() + "]. to a temporary location on this system.  You can alternatively define the 'pi4j.library.path' system property to override this behavior and specify the library path.\n UNDERLYING EXCEPTION: [" + e.getClass().getName() + "]=" + e.getMessage());
        }
    }

    public static void loadLibraryFromClasspath(String path) throws IOException {
        Path inputPath = Paths.get(path, new String[0]);
        if (!inputPath.isAbsolute()) {
            throw new IllegalArgumentException("The path has to be absolute, but found: " + String.valueOf(inputPath));
        }
        String fileNameFull = inputPath.getFileName().toString();
        int dotIndex = fileNameFull.indexOf(46);
        if (dotIndex < 0 || dotIndex >= fileNameFull.length() - 1) {
            throw new IllegalArgumentException("The path has to end with a file name and extension, but found: " + fileNameFull);
        }
        String fileName = fileNameFull.substring(0, dotIndex);
        String extension = fileNameFull.substring(dotIndex);
        Path target = Files.createTempFile(fileName, extension, new FileAttribute[0]);
        File targetFile = target.toFile();
        targetFile.deleteOnExit();
        try (InputStream source = NativeLibraryLoader.class.getResourceAsStream(inputPath.toString());){
            if (source == null) {
                throw new FileNotFoundException("File " + String.valueOf(inputPath) + " was not found in classpath.");
            }
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
        if (BoardInfoHelper.current().getBoardModel() == BoardModel.UNKNOWN) {
            logger.warn("Can't load the library, board model is unknown");
        } else {
            System.load(target.toAbsolutePath().toString());
        }
    }
}

