/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.pigpio.impl;

import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.library.pigpio.PiGpioError;
import com.pi4j.library.pigpio.PiGpioException;
import com.pi4j.library.pigpio.PiGpioPacket;
import com.pi4j.library.pigpio.PiGpioStateChangeEvent;
import com.pi4j.library.pigpio.PiGpioStateChangeListener;
import com.pi4j.library.pigpio.internal.PIGPIO;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PiGpioBase
implements PiGpio {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Set<Integer> serialHandles = Collections.synchronizedSet(new HashSet());
    protected final Set<Integer> i2cHandles = Collections.synchronizedSet(new HashSet());
    protected final Set<Integer> spiHandles = Collections.synchronizedSet(new HashSet());
    protected List<PiGpioStateChangeListener> stateChangeListeners = new CopyOnWriteArrayList<PiGpioStateChangeListener>();
    protected Map<Integer, List<PiGpioStateChangeListener>> pinChangeListeners = new ConcurrentHashMap<Integer, List<PiGpioStateChangeListener>>();
    protected boolean initialized = false;

    protected void closeAllOpenHandles() {
        this.spiHandles.forEach(handle -> {
            this.logger.trace("[SHUTDOWN] -- CLOSING OPEN SPI HANDLE: [{}]", handle);
            this.spiClose((int)handle);
        });
        this.serialHandles.forEach(handle -> {
            this.logger.trace("[SHUTDOWN] -- CLOSING OPEN SERIAL HANDLE: [{}]", handle);
            this.serClose((int)handle);
        });
        this.i2cHandles.forEach(handle -> {
            this.logger.trace("[SHUTDOWN] -- CLOSING OPEN I2C HANDLE: [{}]", handle);
            this.i2cClose((int)handle);
        });
    }

    protected void validateReady() {
        this.validateInitialized();
    }

    protected void validateInitialized() {
        if (!this.initialized) {
            throw new PiGpioException("PIGPIO NOT INITIALIZED; make sure you call the PiGpio::initialize() function first.");
        }
    }

    protected void validateUserPin(int pin) throws IllegalArgumentException {
        this.validatePin(pin, true);
    }

    protected void validatePin(int pin) throws IllegalArgumentException {
        this.validatePin(pin, false);
    }

    protected void validatePin(int pin, boolean userPin) throws IllegalArgumentException {
        int max;
        int min2 = 0;
        int n = max = userPin ? 31 : 53;
        if (pin < min2 || pin > max) {
            throw new IllegalArgumentException("Invalid PIN number: " + pin + "; (supported pins: " + min2 + "-" + max + ")");
        }
    }

    protected void validateDutyCycle(int dutyCycle) throws IllegalArgumentException {
        int min2 = 0;
        int max = 40000;
        if (dutyCycle < min2 || dutyCycle > max) {
            throw new IllegalArgumentException("Invalid Duty Cycle: " + dutyCycle + "; (supported duty-cycle: " + min2 + " - " + max + ")");
        }
    }

    protected void validateDutyCycleRange(int range) throws IllegalArgumentException {
        int min2 = 25;
        int max = 40000;
        if (range < min2 || range > max) {
            throw new IllegalArgumentException("Invalid Duty Cycle Range: " + range + "; (supported range: " + min2 + " - " + max + ")");
        }
    }

    protected void validatePulseWidth(int pulseWidth) throws IllegalArgumentException {
        if (pulseWidth == 0) {
            return;
        }
        int min2 = 500;
        int max = 2500;
        if (pulseWidth < min2 || pulseWidth > max) {
            throw new IllegalArgumentException("Invalid Pulse-Width: " + pulseWidth + "; (supported pulse-width: " + min2 + " - " + max + ")");
        }
    }

    protected void validateDelayMicroseconds(long micros) {
        int min2 = 0;
        int max = 1000000;
        if (micros < (long)min2 || micros > (long)max) {
            throw new IllegalArgumentException("Invalid microseconds delay: " + micros + "; (supported range: " + min2 + " - " + max + ")");
        }
    }

    protected void validateDelayMilliseconds(int millis) {
        int min2 = 0;
        int max = 60000;
        if (millis < min2 || millis > max) {
            throw new IllegalArgumentException("Invalid milliseconds delay: " + millis + "; (supported range: " + min2 + " - " + max + ")");
        }
    }

    protected void validateResult(PiGpioPacket result) {
        this.validateResult(result.result());
    }

    protected void validateResult(PiGpioPacket result, boolean throwException) {
        this.validateResult(result.result(), throwException);
    }

    protected void validateResult(long value) {
        this.validateResult(value, true);
    }

    protected void validateResult(long value, boolean throwException) {
        if (value < 0L) {
            PiGpioError err = PiGpioError.from(value);
            this.logger.warn("PIGPIO ERROR: " + err.name() + "; " + err.message());
            if (throwException) {
                throw new PiGpioException("PIGPIO ERROR: " + err.name() + "; " + err.message());
            }
        }
    }

    protected void validateHandle(int handle) {
        if (handle < 0) {
            throw new IllegalArgumentException("PIGPIO ERROR: INVALID I2C/SPI/SERIAL HANDLE [" + handle + "]; Valid range: >0");
        }
    }

    protected void validateI2cRegister(int register) {
        if (register < 0 || register > 255) {
            throw new IllegalArgumentException("PIGPIO ERROR: INVALID I2C REGISTER [" + register + "]; Valid range: 0-255");
        }
    }

    protected void validateI2cDeviceAddress(int device) {
        if (device < 0 || device > 127) {
            throw new IllegalArgumentException("PIGPIO ERROR: INVALID I2C DEVICE ADDRESS [" + device + "]; Valid range: 0-127");
        }
    }

    protected void validateI2cBus(int bus) {
        if (bus < 0) {
            throw new IllegalArgumentException("PIGPIO ERROR: INVALID I2C BUS [" + bus + "]; Valid range: >=0");
        }
    }

    protected void validateI2cBlockLength(int length) {
        if (length < 0 || length > 32) {
            throw new IllegalArgumentException("PIGPIO ERROR: INVALID I2C PAYLOAD DATA LENGTH [" + length + "]; Valid range: 0-32");
        }
    }

    protected void validateGpioGlitchFilter(int interval) {
        if (interval < 0 || interval > 300000) {
            throw new IllegalArgumentException("PIGPIO ERROR: INVALID GPIO GLITCH FILTER INTERVAL [" + interval + "]; Valid range: 0-300000");
        }
    }

    protected void validateGpioNoiseFilter(int steady, int active) {
        if (steady < 0 || steady > 300000) {
            throw new IllegalArgumentException("PIGPIO ERROR: INVALID GPIO NOISE FILTER -> STEADY INTERVAL [" + steady + " us]; Valid range: 0-300000");
        }
        if (active < 0 || active > 1000000) {
            throw new IllegalArgumentException("PIGPIO ERROR: INVALID GPIO NOISE FILTER -> ACTIVE INTERVAL [" + steady + " us]; Valid range: 0-1000000");
        }
    }

    @Override
    public boolean isInitialised() {
        return this.initialized;
    }

    @Override
    public void addPinListener(int pin, PiGpioStateChangeListener listener) {
        List<PiGpioStateChangeListener> listeners = null;
        if (this.pinChangeListeners.containsKey(pin)) {
            listeners = this.pinChangeListeners.get(pin);
        } else if (!this.pinChangeListeners.containsKey(pin)) {
            listeners = new CopyOnWriteArrayList<PiGpioStateChangeListener>();
            this.pinChangeListeners.put(pin, listeners);
        }
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
        this.gpioEnableNotifications(pin);
    }

    @Override
    public void removePinListener(int pin, PiGpioStateChangeListener listener) {
        List<PiGpioStateChangeListener> listeners = null;
        if (!this.pinChangeListeners.containsKey(pin)) {
            return;
        }
        listeners = this.pinChangeListeners.get(pin);
        if (!listeners.contains(listener)) {
            listeners.remove(listener);
        }
        if (listeners.isEmpty()) {
            this.gpioDisableNotifications(pin);
        }
    }

    @Override
    public void removePinListeners(int pin) {
        List<PiGpioStateChangeListener> listeners = null;
        if (!this.pinChangeListeners.containsKey(pin)) {
            return;
        }
        listeners = this.pinChangeListeners.get(pin);
        listeners.clear();
        this.gpioDisableNotifications(pin);
    }

    @Override
    public void removeAllPinListeners() {
        this.pinChangeListeners.clear();
    }

    @Override
    public void addListener(PiGpioStateChangeListener listener) {
        if (!this.stateChangeListeners.contains(listener)) {
            this.stateChangeListeners.add(listener);
        }
    }

    @Override
    public void removeListener(PiGpioStateChangeListener listener) {
        if (this.stateChangeListeners.contains(listener)) {
            this.stateChangeListeners.remove(listener);
        }
    }

    @Override
    public void removeAllListeners() {
        this.stateChangeListeners.clear();
    }

    protected void dispatchEvent(PiGpioStateChangeEvent event) {
        try {
            this.stateChangeListeners.forEach(listener -> {
                try {
                    listener.onChange(event);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), e);
                }
            });
            int pin = event.pin();
            if (this.pinChangeListeners.containsKey(pin)) {
                List<PiGpioStateChangeListener> listeners = this.pinChangeListeners.get(pin);
                listeners.forEach(listener -> {
                    try {
                        listener.onChange(event);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), e);
                    }
                });
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    @Override
    public String gpioHardwareRevisionString() {
        this.logger.trace("[HARDWARE] -> GET REVISION (STRING)");
        this.validateReady();
        long revision = this.gpioHardwareRevision();
        String revisionString = Integer.toHexString((int)revision);
        this.logger.trace("[HARDWARE] <- REVISION (STRING): {}", (Object)revisionString);
        return revisionString;
    }

    @Override
    public int gpioCfgClock(int cfgMicros, int cfgPeripheral, int cfgSource) {
        this.logger.trace("[gpioCfgClock] -> STARTED");
        if (this.initialized) {
            this.logger.error("pigpio is already initialized - this call will have no effect");
            throw new PiGpioException("pigpio is already initialized - this call will have no effect");
        }
        int rc = PIGPIO.gpioCfgClock(cfgMicros, cfgPeripheral, cfgSource);
        this.logger.trace("[gpioCfgClock] <- FINISHED. Return code={}", (Object)rc);
        return rc;
    }
}

