/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.pigpio.test;

import com.pi4j.library.pigpio.internal.PIGPIO;
import com.pi4j.library.pigpio.internal.PiGpioAlertCallback;
import com.pi4j.library.pigpio.internal.PiGpioAlertCallbackEx;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestGpioAlertRaw {
    private static final Logger logger = LoggerFactory.getLogger(TestGpioAlertRaw.class);
    public static int GPIO_PIN = 21;

    public static void main(String[] args) throws IOException {
        String loglevel = "INFO";
        if (args != null && args.length > 0) {
            Level lvl = Level.valueOf(args[0].toUpperCase());
            loglevel = lvl.name();
        }
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", loglevel);
        logger.info("");
        logger.info("");
        logger.info("-----------------------------------------------------");
        logger.info("-----------------------------------------------------");
        logger.info("Pi4J Library :: PIGPIO JNI (Raw) Wrapper Library");
        logger.info("-----------------------------------------------------");
        logger.info("-----------------------------------------------------");
        logger.info("PIGPIO VERSION   : " + PIGPIO.gpioVersion());
        logger.info("PIGPIO HARDWARE  : " + Integer.toHexString(PIGPIO.gpioHardwareRevision()));
        int init = PIGPIO.gpioInitialise();
        if (init < 0) {
            logger.error("ERROR; PIGPIO INIT FAILED; ERROR CODE: " + init);
        } else {
            logger.info("-----------------------------------------------------");
            logger.info("PIGPIO INITIALIZED SUCCESSFULLY");
            logger.info("-----------------------------------------------------");
            PIGPIO.gpioSetMode(GPIO_PIN, 0);
            PIGPIO.gpioSetPullUpDown(GPIO_PIN, 1);
            PIGPIO.gpioGlitchFilter(GPIO_PIN, 100000);
            PIGPIO.gpioSetAlertFunc(GPIO_PIN, new PiGpioAlertCallback(){

                @Override
                public void call(int pin, int state, long tick) {
                    logger.info("RECEIVED ALERT EVENT! " + pin + " : " + state + " :" + tick);
                }
            });
            System.in.read();
            logger.info("PIGPIO ALERT CALLBACK REMOVED");
            PIGPIO.gpioSetAlertFunc(GPIO_PIN, null);
            System.in.read();
            logger.info("PIGPIO ALERT EXTENDED CALLBACK ADDED");
            String testdata = "Hello World!";
            PIGPIO.gpioSetAlertFuncEx(GPIO_PIN, new PiGpioAlertCallbackEx(){

                @Override
                public void call(int pin, int state, long tick, Object userdata) {
                    logger.info("RECEIVED ALERT EVENT! " + pin + " : " + state + " :" + tick + " : " + String.valueOf(userdata));
                }
            }, testdata);
            System.in.read();
            logger.info("PIGPIO ALERT CALLBACK REMOVED");
            PIGPIO.gpioSetAlertFunc(GPIO_PIN, null);
            System.in.read();
            logger.info("-----------------------------------------------------");
            PIGPIO.gpioTerminate();
            logger.info("PIGPIO TERMINATED");
        }
        logger.info("-----------------------------------------------------");
        logger.info("");
        logger.info("");
    }
}

