/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.pigpio.test;

import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.library.pigpio.util.StringUtil;
import java.util.Arrays;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestI2C {
    private static final Logger logger = LoggerFactory.getLogger(TestI2C.class);
    private static int I2C_BUS = 1;
    private static int I2C_DEVICE = 4;

    public static void main(String[] args) {
        PiGpio piGpio = PiGpio.newNativeInstance();
        piGpio.gpioInitialise();
        logger.info("PIGPIO INITIALIZED");
        logger.info("PIGPIO VERSION   : " + piGpio.gpioVersion());
        logger.info("PIGPIO HARDWARE  : " + piGpio.gpioHardwareRevision());
        int handle = piGpio.i2cOpen(I2C_BUS, I2C_DEVICE);
        logger.info("PIGPIO I2C OPEN  : " + handle);
        if (handle < 0) {
            logger.error("ERROR; I2C OPEN FAILED: ERROR CODE: " + handle);
            System.exit(handle);
        }
        logger.info("");
        logger.info("----------------------------------------");
        logger.info("TEST I2C SINGLE BYTE RAW READ/WRITE");
        logger.info("----------------------------------------");
        for (int b = 0; b < 255; ++b) {
            logger.info("[W/R BYTE]");
            logger.info(" (WRITE) 0x" + Integer.toHexString(b));
            int result = piGpio.i2cWriteByte(handle, (byte)b);
            if (result < 0) {
                logger.error("\nERROR; I2C WRITE FAILED: ERROR CODE: " + result);
                System.exit(result);
            }
            if ((result = piGpio.i2cReadByte(handle)) < 0) {
                logger.error("\nERROR; I2C READ FAILED: ERROR CODE: " + result);
                System.exit(result);
            }
            logger.info(" (READ) 0x" + Integer.toHexString(result));
            logger.info("");
            int expected = b;
            int received = result;
            if (received == expected) continue;
            logger.error("\nERROR; I2C READ FAILED: BYTE MISMATCH: expected=" + expected + "; received=" + received);
            System.exit(0);
        }
        for (int x = 1; x < 100; ++x) {
            logger.info("[W/R BUFFER]");
            Random r = new Random();
            int len = r.nextInt(20) + 4;
            byte[] writeBuffer = new byte[len];
            r.nextBytes(writeBuffer);
            logger.info(" (WRITE) 0x" + StringUtil.toHexString(writeBuffer));
            int result = piGpio.i2cWriteDevice(handle, writeBuffer);
            if (result < 0) {
                logger.error("\nERROR; I2C WRITE FAILED: ERROR CODE: " + result);
                System.exit(result);
            }
            byte[] readBuffer = new byte[len];
            result = piGpio.i2cReadDevice(handle, readBuffer);
            logger.info(" (READ) 0x" + StringUtil.toHexString(readBuffer));
            logger.info("");
            if (result < 0) {
                logger.error("\nERROR; I2C READ FAILED: ERROR CODE: " + result);
                System.exit(result);
            }
            if (result != len) {
                logger.error("\nERROR; I2C READ FAILED: LENGTH MISMATCH: " + result);
                System.exit(result);
            }
            if (Arrays.equals(writeBuffer, readBuffer)) continue;
            logger.error("\nERROR; I2C READ FAILED: BYTE MISMATCH: expected=" + StringUtil.toHexString(writeBuffer) + "; received=" + StringUtil.toHexString(readBuffer));
            System.exit(0);
        }
        piGpio.i2cClose(handle);
        piGpio.gpioTerminate();
        logger.info("PIGPIO TERMINATED");
        logger.info("ALL I2C RAW DEVICE TESTS COMPLETED SUCCESSFULLY");
    }
}

