/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.library.pigpio.util;

import java.nio.ByteBuffer;
import java.util.Arrays;

public class StringUtil {
    public static final String EMPTY = "";
    public static final char DEFAULT_PAD_CHAR = ' ';

    public static boolean isNullOrEmpty(String data, boolean trim) {
        if (data == null) {
            return true;
        }
        String test = data;
        if (trim) {
            test = data.trim();
        }
        return test.length() <= 0;
    }

    public static boolean isNullOrEmpty(String data) {
        return StringUtil.isNullOrEmpty(data, false);
    }

    public static boolean isNotNullOrEmpty(String data) {
        return StringUtil.isNotNullOrEmpty(data, false);
    }

    public static boolean isNotNullOrEmpty(String data, boolean trim) {
        return !StringUtil.isNullOrEmpty(data, trim);
    }

    public static String setIfNullOrEmpty(String data, String replacement, boolean trim) {
        if (StringUtil.isNullOrEmpty(data, trim)) {
            return replacement;
        }
        return data;
    }

    public static String setIfNullOrEmpty(String data, String replacement) {
        return StringUtil.setIfNullOrEmpty(data, replacement, false);
    }

    public static boolean contains(String source, String target) {
        return null != source && null != target && source.contains(target);
    }

    public static boolean contains(String source, String[] targets) {
        if (null != source && null != targets) {
            for (String target : targets) {
                if (!source.contains(target)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(String[] sources, String target) {
        if (null != sources && null != target) {
            for (String source : sources) {
                if (!StringUtil.contains(source, target)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(String[] sources, String[] targets) {
        if (null != sources && null != targets) {
            for (String source : sources) {
                if (!StringUtil.contains(source, targets)) continue;
                return true;
            }
        }
        return false;
    }

    public static String create(int length) {
        return StringUtil.create(' ', length);
    }

    public static String create(char c, int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int index = 0; index < length; ++index) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static String create(String s2, int length) {
        StringBuilder sb = new StringBuilder(length * s2.length());
        for (int index = 0; index < length; ++index) {
            sb.append(s2);
        }
        return sb.toString();
    }

    public static String repeat(char c, int length) {
        return StringUtil.create(c, length);
    }

    public static String repeat(String s2, int length) {
        return StringUtil.create(s2, length);
    }

    public static String padLeft(String data, int length) {
        return StringUtil.padLeft(data, ' ', length);
    }

    public static String padLeft(String data, char pad, int length) {
        StringBuilder sb = new StringBuilder(data.length() + length);
        for (int index = 0; index < length; ++index) {
            sb.append(pad);
        }
        sb.append(data);
        return sb.toString();
    }

    public static String padLeft(String data, String pad, int length) {
        StringBuilder sb = new StringBuilder(data.length() + length * pad.length());
        for (int index = 0; index < length; ++index) {
            sb.append(pad);
        }
        sb.append(data);
        return sb.toString();
    }

    public static String padRight(String data, int length) {
        return StringUtil.padRight(data, ' ', length);
    }

    public static String padRight(String data, char pad, int length) {
        StringBuilder sb = new StringBuilder(data.length() + length);
        sb.append(data);
        for (int index = 0; index < length; ++index) {
            sb.append(pad);
        }
        return sb.toString();
    }

    public static String padRight(String data, String pad, int length) {
        StringBuilder sb = new StringBuilder(data.length() + length * pad.length());
        sb.append(data);
        for (int index = 0; index < length; ++index) {
            sb.append(pad);
        }
        return sb.toString();
    }

    public static String pad(String data, int length) {
        return StringUtil.pad(data, ' ', length);
    }

    public static String pad(String data, char pad, int length) {
        return StringUtil.create(pad, length) + data + StringUtil.create(pad, length);
    }

    public static String pad(String data, String pad, int length) {
        return StringUtil.create(pad, length) + data + StringUtil.create(pad, length);
    }

    public static String padCenter(String data, int length) {
        return StringUtil.padCenter(data, ' ', length);
    }

    public static String padCenter(String data, char pad, int length) {
        if (data.length() < length) {
            int needed = length - data.length();
            int padNeeded = needed / 2;
            StringBuilder result = new StringBuilder();
            result.append(StringUtil.create(pad, padNeeded));
            result.append(data);
            result.append(StringUtil.create(pad, padNeeded));
            int remaining = length - result.length();
            result.append(StringUtil.create(pad, remaining));
            return result.toString();
        }
        return data;
    }

    public static String trimLeft(String data) {
        return StringUtil.trimLeft(data, ' ');
    }

    public static String trimLeft(String data, char trim) {
        for (int index = 0; index < data.length(); ++index) {
            if (data.charAt(index) == trim) continue;
            return data.substring(index);
        }
        return EMPTY;
    }

    public static String trimRight(String data) {
        return StringUtil.trimRight(data, ' ');
    }

    public static String trimRight(String data, char trim) {
        int count = 0;
        for (int index = data.length(); index > 0; --index) {
            if (data.charAt(index - 1) == trim) {
                ++count;
                continue;
            }
            return data.substring(0, data.length() - count);
        }
        return EMPTY;
    }

    public static String trim(String data) {
        return StringUtil.trim(data, ' ');
    }

    public static String trim(String data, char trim) {
        String result = StringUtil.trimLeft(data, trim);
        return StringUtil.trimRight(result, trim);
    }

    public static String center(String text, int length) {
        String out = String.format("%" + length + "s%s%" + length + "s", EMPTY, text, EMPTY);
        int mid = out.length() / 2;
        int start = mid - length / 2;
        int end = start + length;
        return out.substring(start, end);
    }

    public static String concat(String ... data) {
        StringBuilder sb = new StringBuilder();
        for (String d : data) {
            sb.append(d);
        }
        return sb.toString();
    }

    public static void appendHexString(StringBuilder builder, byte byt) {
        builder.append(String.format("%02X", byt));
    }

    public static String toHexString(byte byt) {
        return String.format("%02X", byt);
    }

    public static void appendHexString(StringBuilder builder, int byt) {
        builder.append(String.format("%02X", (byte)byt));
    }

    public static String toHexString(int byt) {
        return String.format("%02X", (byte)byt);
    }

    public static void appendHexString(StringBuilder builder, byte[] bytes) {
        for (byte b : bytes) {
            builder.append(String.format("%02X ", b));
        }
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        StringUtil.appendHexString(sb, bytes);
        return sb.toString().trim();
    }

    public static void appendHexString(StringBuilder builder, ByteBuffer buffer) {
        StringUtil.appendHexString(builder, buffer.array());
    }

    public static String toHexString(ByteBuffer buffer) {
        StringBuilder sb = new StringBuilder();
        StringUtil.appendHexString(sb, buffer);
        return sb.toString().trim();
    }

    public static void appendHexString(StringBuilder builder, byte[] bytes, int offset, int length) {
        StringUtil.appendHexString(builder, Arrays.copyOfRange(bytes, offset, length));
    }

    public static String toHexString(byte[] bytes, int offset, int length) {
        StringBuilder sb = new StringBuilder();
        StringUtil.appendHexString(sb, bytes, offset, length);
        return sb.toString().trim();
    }

    public static void appendHexString(StringBuilder builder, ByteBuffer buffer, int offset, int length) {
        StringUtil.appendHexString(builder, buffer.array(), offset, length);
    }

    public static String toHexString(ByteBuffer buffer, int offset, int length) {
        StringBuilder sb = new StringBuilder();
        StringUtil.appendHexString(sb, buffer, offset, offset + length);
        return sb.toString().trim();
    }
}

