/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.gpiod.provider.gpio.digital;

import com.pi4j.context.Context;
import com.pi4j.exception.InitializeException;
import com.pi4j.exception.ShutdownException;
import com.pi4j.io.gpio.digital.DigitalInput;
import com.pi4j.io.gpio.digital.DigitalInputBase;
import com.pi4j.io.gpio.digital.DigitalInputConfig;
import com.pi4j.io.gpio.digital.DigitalInputProvider;
import com.pi4j.io.gpio.digital.DigitalState;
import com.pi4j.library.gpiod.internal.GpioDContext;
import com.pi4j.library.gpiod.internal.GpioDException;
import com.pi4j.library.gpiod.internal.GpioLine;
import com.pi4j.library.gpiod.internal.LineDirection;
import com.pi4j.library.gpiod.internal.LineRequestFlag;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GpioDDigitalInput
extends DigitalInputBase
implements DigitalInput {
    private static final Logger logger = LoggerFactory.getLogger(GpioDDigitalInput.class);
    private static final long inputMaxWaitNs = 10000000L;
    private final GpioLine line;
    private final long debounceNs;
    private volatile boolean inputListenerRun;
    private volatile boolean inputListenerActive;
    private Future<?> inputListener;

    public GpioDDigitalInput(GpioLine line, DigitalInputProvider provider, DigitalInputConfig config) {
        super(provider, config);
        this.line = line;
        this.debounceNs = config.getDebounce() == 0L ? 0L : 1000L * config.getDebounce();
    }

    @Override
    public DigitalInput initialize(Context context) throws InitializeException {
        try {
            if (this.line.getDirection() == LineDirection.OUTPUT) {
                GpioDContext.getInstance().closeLine(this.line);
            }
            switch (((DigitalInputConfig)this.config).getPull()) {
                case PULL_UP: {
                    this.line.requestBothEdgeEventsFlags(((DigitalInputConfig)this.config).getId(), LineRequestFlag.BIAS_PULL_UP.getVal());
                    break;
                }
                case PULL_DOWN: {
                    this.line.requestBothEdgeEventsFlags(((DigitalInputConfig)this.config).getId(), LineRequestFlag.BIAS_PULL_DOWN.getVal());
                    break;
                }
                case OFF: {
                    this.line.requestBothEdgeEventsFlags(((DigitalInputConfig)this.config).getId(), LineRequestFlag.BIAS_DISABLE.getVal());
                }
            }
        }
        catch (GpioDException e) {
            throw new InitializeException("Failed to initialize input " + this.id, e);
        }
        super.initialize(context);
        this.inputListenerRun = true;
        this.inputListener = context.submitTask(this::monitorLineEvents);
        return this;
    }

    @Override
    public DigitalInput shutdown(Context context) throws ShutdownException {
        super.shutdown(context);
        if (this.inputListener != null) {
            this.shutdownInputListener();
        }
        return this;
    }

    private void shutdownInputListener() {
        this.inputListenerRun = true;
        if (!this.inputListenerActive) {
            return;
        }
        if (this.inputListener.isDone()) {
            return;
        }
        if (!this.inputListener.cancel(true)) {
            logger.error("Failed to cancel input listener!");
        }
        long start = System.currentTimeMillis();
        while (this.inputListenerActive) {
            if (System.currentTimeMillis() - start > 5000L) {
                throw new IllegalArgumentException("Input listener didn't stop in 5s");
            }
            try {
                Thread.sleep(0L, 500);
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted, while waiting for input listener to stop");
            }
        }
        logger.info("Shutdown input listener for " + this.id);
    }

    @Override
    public DigitalState state() {
        return DigitalState.getState(this.line.getValue());
    }

    /*
     * Exception decompiling
     */
    private void monitorLineEvents() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

