/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.linuxfs.provider.i2c;

import com.pi4j.context.Context;
import com.pi4j.exception.ShutdownException;
import com.pi4j.io.i2c.I2C;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.io.i2c.I2CProvider;
import com.pi4j.io.i2c.I2CProviderBase;
import com.pi4j.plugin.linuxfs.provider.i2c.LinuxFsI2C;
import com.pi4j.plugin.linuxfs.provider.i2c.LinuxFsI2CBus;
import com.pi4j.plugin.linuxfs.provider.i2c.LinuxFsI2CProvider;
import java.util.HashMap;
import java.util.Map;

public class LinuxFsI2CProviderImpl
extends I2CProviderBase
implements LinuxFsI2CProvider {
    private final Map<Integer, LinuxFsI2CBus> i2CBusMap;

    public LinuxFsI2CProviderImpl() {
        this.id = "linuxfs-i2c";
        this.name = "LinuxFS I2C Provider";
        this.i2CBusMap = new HashMap<Integer, LinuxFsI2CBus>();
    }

    @Override
    public int getPriority() {
        return 150;
    }

    @Override
    public synchronized I2C create(I2CConfig config) {
        LinuxFsI2CBus i2CBus = this.i2CBusMap.computeIfAbsent(config.getBus(), busNr -> new LinuxFsI2CBus(config));
        LinuxFsI2C i2C = new LinuxFsI2C(i2CBus, this, config);
        this.context.registry().add(i2C);
        return i2C;
    }

    @Override
    public I2CProvider shutdown(Context context) throws ShutdownException {
        this.i2CBusMap.forEach((busNr, bus) -> bus.close());
        this.i2CBusMap.clear();
        return (I2CProvider)super.shutdown(context);
    }
}

