/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.linuxfs.provider.pwm;

import com.pi4j.context.Context;
import com.pi4j.exception.InitializeException;
import com.pi4j.exception.ShutdownException;
import com.pi4j.io.exception.IOException;
import com.pi4j.io.pwm.Pwm;
import com.pi4j.io.pwm.PwmBase;
import com.pi4j.io.pwm.PwmConfig;
import com.pi4j.io.pwm.PwmPolarity;
import com.pi4j.io.pwm.PwmProvider;
import com.pi4j.plugin.linuxfs.internal.LinuxPwm;
import com.pi4j.util.Frequency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxFsPwm
extends PwmBase
implements Pwm {
    protected final LinuxPwm pwm;
    protected int actualFrequency = -1;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean initializing = false;

    public LinuxFsPwm(LinuxPwm pwm, PwmProvider provider, PwmConfig config) {
        super(provider, config);
        this.pwm = pwm;
    }

    @Override
    public Pwm initialize(Context context) throws InitializeException {
        this.logger.trace("initializing PWM [" + ((PwmConfig)this.config).address() + "]; " + this.pwm.getPwmPath());
        try {
            if (((PwmConfig)this.config).address() >= this.pwm.channels()) {
                throw new InitializeException("Unsupported pin/channel by PWM chipset for PWM [" + ((PwmConfig)this.config).address() + "] @ <" + this.pwm.systemPath() + ">");
            }
        }
        catch (java.io.IOException e) {
            this.logger.error(e.getMessage(), e);
            throw new InitializeException("Unable to get number of pins/channels supported by PWM chipset for PWM [" + ((PwmConfig)this.config).address() + "] @ <" + this.pwm.systemPath() + ">; " + e.getMessage(), e);
        }
        try {
            if (!this.pwm.isExported()) {
                this.logger.trace("exporting PWM [" + ((PwmConfig)this.config).address() + "]; " + this.pwm.getPwmPath());
                this.pwm.export();
                Thread.sleep(70L);
            } else {
                this.logger.trace("PWM [" + ((PwmConfig)this.config).address() + "] is already exported; " + this.pwm.getPwmPath());
            }
        }
        catch (java.io.IOException e) {
            this.logger.error(e.getMessage(), e);
            throw new InitializeException("Unable to export PWM [" + ((PwmConfig)this.config).address() + "] @ <" + this.pwm.systemPath() + ">; " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), e);
            throw new InitializeException("Programmed delay failure, unable to export PWM [" + ((PwmConfig)this.config).address() + "] @ <" + this.pwm.systemPath() + ">; " + e.getMessage(), e);
        }
        super.initialize(context);
        return this;
    }

    @Override
    public Pwm on() throws IOException {
        try {
            if (this.pwm.dutyCycle() > 0L) {
                this.pwm.dutyCycle(0L);
            }
            if (this.pwm.enabled()) {
                this.pwm.disable();
            }
            this.onState = false;
            if (this.frequency <= 0) {
                return this;
            }
            long period = Frequency.nanoseconds(this.frequency);
            this.logger.trace("set 'period' of PWM [" + ((PwmConfig)this.config).address() + "] to [" + Long.toUnsignedString(period) + "]; " + this.pwm.getPwmPath());
            this.pwm.period(period);
            long dcycle = Math.round((float)period * this.dutyCycle / 100.0f);
            this.logger.trace("set 'duty_cycle' of PWM [" + ((PwmConfig)this.config).address() + "] to [" + dcycle + "]; " + this.pwm.getPwmPath());
            this.pwm.dutyCycle(dcycle);
            this.logger.trace("set 'polarity' of PWM [" + ((PwmConfig)this.config).address() + "] to [" + this.polarity.getName() + "]; " + this.pwm.getPwmPath());
            this.pwm.polarity(this.polarity == PwmPolarity.INVERSED ? LinuxPwm.Polarity.INVERSED : LinuxPwm.Polarity.NORMAL);
            this.logger.trace("enable PWM [" + ((PwmConfig)this.config).address() + "]; " + this.pwm.getPwmPath());
            this.pwm.enable();
            this.onState = true;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            throw new IOException(e);
        }
        return this;
    }

    @Override
    public Pwm off() throws IOException {
        try {
            this.logger.trace("disable PWM [" + ((PwmConfig)this.config).address() + "]; " + this.pwm.getPwmPath());
            this.pwm.disable();
            this.onState = false;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            throw new IOException("Unable to disable (OFF) PWM [" + ((PwmConfig)this.config).address() + "] @ <" + this.pwm.pwmPath() + ">; " + e.getMessage(), e);
        }
        return this;
    }

    @Override
    public boolean isOn() {
        try {
            return this.pwm.isEnabled();
        }
        catch (java.io.IOException e) {
            this.logger.error(e.getMessage(), e);
            throw new IOException("Unable to get ON (enabled) state from PWM [" + ((PwmConfig)this.config).address() + "] @ <" + this.pwm.pwmPath() + ">; " + e.getMessage(), e);
        }
    }

    @Override
    public int getActualFrequency() throws IOException {
        try {
            long period = this.pwm.period();
            this.actualFrequency = Frequency.getFrequencyFromNanos(period);
            return this.actualFrequency;
        }
        catch (java.io.IOException e) {
            this.logger.error(e.getMessage(), e);
            throw new IOException("Unable to read PWM [" + ((PwmConfig)this.config).address() + "] period @ <" + this.pwm.pwmPath() + ">; " + e.getMessage(), e);
        }
    }

    @Override
    public Pwm shutdown(Context context) throws ShutdownException {
        this.logger.trace("shutdown PWM [" + ((PwmConfig)this.config).address() + "]; " + this.pwm.getPwmPath());
        if (((PwmConfig)this.config()).shutdownValue() != null) {
            return super.shutdown(context);
        }
        try {
            this.logger.trace("un-exporting PWM [" + ((PwmConfig)this.config).address() + "]; " + this.pwm.getPwmPath());
            if (this.pwm.isExported()) {
                this.pwm.unexport();
            }
        }
        catch (java.io.IOException e) {
            this.logger.error(e.getMessage(), e);
            throw new ShutdownException("Failed to UN-EXPORT PWM [" + ((PwmConfig)this.config()).address() + "] @ <" + this.pwm.systemPath() + ">; " + e.getMessage(), e);
        }
        return this;
    }
}

