/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.mock.provider.i2c;

import com.pi4j.io.i2c.I2C;
import com.pi4j.io.i2c.I2CBase;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.io.i2c.I2CProvider;
import com.pi4j.io.i2c.I2CRegisterDataReader;
import com.pi4j.io.i2c.I2CRegisterDataWriter;
import com.pi4j.plugin.mock.provider.i2c.MockI2CBus;
import com.pi4j.util.StringUtil;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockI2C
extends I2CBase<MockI2CBus>
implements I2C,
I2CRegisterDataReader,
I2CRegisterDataWriter {
    private static final Logger logger = LoggerFactory.getLogger(MockI2C.class);
    protected ArrayDeque<Byte>[] registers = new ArrayDeque[512];
    protected ArrayDeque<Byte> raw = new ArrayDeque();

    public MockI2C(I2CProvider provider, I2CConfig config) {
        super(provider, config, new MockI2CBus(config));
        logger.debug("[{}::{}] :: CREATE(BUS={}; DEVICE={})", "Mock I2C Provider", this.id, config.bus(), config.device());
    }

    @Override
    public void close() {
        super.close();
        logger.debug("[{}::{}] :: CLOSE(BUS={}; DEVICE={})", "Mock I2C Provider", this.id, ((I2CConfig)this.config).bus(), ((I2CConfig)this.config).device());
    }

    @Override
    public int write(byte b) {
        this.raw.add(b);
        if (logger.isDebugEnabled()) {
            logger.debug("[{}::{}] :: WRITE(0x{})", "Mock I2C Provider", this.id, StringUtil.toHexString(b));
        }
        return 0;
    }

    @Override
    public int write(byte[] data, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, data.length);
        int p = offset;
        while (p - offset < length) {
            this.raw.add(data[p]);
            ++p;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[{}::{}] :: WRITE(0x{})", "Mock I2C Provider", this.id, StringUtil.toHexString(data, offset, length));
        }
        return length;
    }

    @Override
    public int write(Charset charset, CharSequence data) {
        byte[] buffer;
        for (byte b : buffer = data.toString().getBytes(charset)) {
            this.raw.add(b);
        }
        logger.debug("[{}::{}] :: WRITE(0x{})", "Mock I2C Provider", this.id, data);
        return data.length();
    }

    @Override
    public int read() {
        if (this.raw.isEmpty()) {
            return -1;
        }
        byte b = this.raw.pop();
        if (logger.isDebugEnabled()) {
            logger.debug("[{}::{}] :: READ(0x{})", "Mock I2C Provider", this.id, StringUtil.toHexString(b));
        }
        return b;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, buffer.length);
        if (this.raw.isEmpty()) {
            return -1;
        }
        int counter = 0;
        for (int p = 0; p < length && p + offset <= buffer.length && !this.raw.isEmpty(); ++p) {
            buffer[offset + p] = this.raw.pop();
            ++counter;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[{}::{}] :: READ(0x{})", "Mock I2C Provider", this.id, StringUtil.toHexString(buffer, offset, length));
        }
        return counter;
    }

    @Override
    public String readString(Charset charset, int length) {
        if (this.raw.isEmpty()) {
            return null;
        }
        byte[] buffer = new byte[length];
        for (int p = 0; p < length && !this.raw.isEmpty(); ++p) {
            buffer[p] = this.raw.pop();
        }
        String result = new String(buffer, charset);
        logger.debug("[{}::{}] :: READ()", "Mock I2C Provider", this.id, result);
        return result;
    }

    @Override
    public int writeRegister(int register, byte b) {
        if (this.registers[register] == null) {
            this.registers[register] = new ArrayDeque();
        }
        this.registers[register].add(b);
        if (logger.isDebugEnabled()) {
            logger.debug("[{}::{}] :: WRITE(REG={}, 0x{})", "Mock I2C Provider", this.id, register, StringUtil.toHexString(b));
        }
        return 0;
    }

    @Override
    public int writeRegister(int register, byte[] data, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, data.length);
        if (this.registers[register] == null) {
            this.registers[register] = new ArrayDeque();
        }
        int p = offset;
        while (p - offset < length) {
            this.registers[register].add(data[p]);
            ++p;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[{}::{}] :: WRITE(REG={}, 0x{})", "Mock I2C Provider", this.id, register, StringUtil.toHexString(data, offset, length));
        }
        return length;
    }

    @Override
    public int writeRegister(byte[] register, byte[] data, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, data.length);
        int internalOffset = (register[0] & 0xFF) + (register[1] << 8);
        if (this.registers[internalOffset] == null) {
            this.registers[internalOffset] = new ArrayDeque();
        }
        int p = offset;
        while (p - offset < length) {
            this.registers[internalOffset].add(data[p]);
            ++p;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[{}::{}] :: WRITEREGISTER(REG=(two byte offset LSB first) {}, Chip register offset Decimal : {}  Hex : {}, offset = {}, User data: 0x{})", "Mock I2C Provider", this.id, StringUtil.toHexString(register, 0, register.length), internalOffset, String.format("%02X", internalOffset), String.format("%02X", offset), StringUtil.toHexString(data, offset, length));
        }
        return length;
    }

    @Override
    public int writeRegister(int register, Charset charset, CharSequence data) {
        if (this.registers[register] == null) {
            this.registers[register] = new ArrayDeque();
        }
        byte[] buffer = data.toString().getBytes(charset);
        for (int p = 0; p < buffer.length; ++p) {
            this.registers[register].add(buffer[p]);
        }
        logger.debug("[{}::{}] :: WRITE(REG={}, 0x{})", "Mock I2C Provider", this.id, register, data);
        return data.length();
    }

    @Override
    public int readRegister(int register) {
        if (this.registers[register] == null) {
            throw new IllegalStateException("No available data to read");
        }
        if (this.registers[register].isEmpty()) {
            throw new IllegalStateException("No available data to read");
        }
        byte b = this.registers[register].pop();
        if (logger.isDebugEnabled()) {
            logger.debug("[{}::{}] :: WRITE(REG={}, 0x{})", "Mock I2C Provider", this.id, register, StringUtil.toHexString(b));
        }
        return b;
    }

    @Override
    public int readRegister(byte[] register, byte[] buffer, int offset, int length) {
        int internalOffset = (register[0] & 0xFF) + (register[1] << 8);
        if (this.registers[internalOffset] == null) {
            return -1;
        }
        if (this.registers[internalOffset].isEmpty()) {
            return -1;
        }
        int counter = 0;
        for (int p = 0; p < length && p + offset <= buffer.length && !this.registers[internalOffset].isEmpty(); ++p) {
            buffer[offset + p] = this.registers[internalOffset].pop();
            ++counter;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[{}::{}] :: READREGISTER(REG= (two byte offset LSB first) {}, offset = {}, Chip register offset Decimal : {}  Hex : {}, 0x{})", "Mock I2C Provider", this.id, StringUtil.toHexString(register, 0, register.length), String.format("%02X", offset), internalOffset, String.format("%02X", internalOffset), StringUtil.toHexString(buffer, offset, length));
        }
        return counter;
    }

    @Override
    public int readRegister(int register, byte[] buffer, int offset, int length) {
        if (this.registers[register] == null) {
            return -1;
        }
        if (this.registers[register].isEmpty()) {
            return -1;
        }
        int counter = 0;
        for (int p = 0; p < length && p + offset <= buffer.length && !this.registers[register].isEmpty(); ++p) {
            buffer[offset + p] = this.registers[register].pop();
            ++counter;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[{}::{}] :: WRITE(REG={}, 0x{})", "Mock I2C Provider", this.id, register, StringUtil.toHexString(buffer, offset, length));
        }
        return counter;
    }

    @Override
    public String readRegisterString(int register, Charset charset, int length) {
        if (this.registers[register] == null) {
            return null;
        }
        if (this.registers[register].isEmpty()) {
            return null;
        }
        byte[] buffer = new byte[length];
        for (int p = 0; p < length && !this.registers[register].isEmpty(); ++p) {
            buffer[p] = this.registers[register].pop();
        }
        String result = new String(buffer, charset);
        logger.debug("[{}::{}] :: WRITE(REG={}, 0x{})", "Mock I2C Provider", this.id, register, result);
        return result;
    }
}

