/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.mock.provider.spi;

import com.pi4j.io.spi.Spi;
import com.pi4j.io.spi.SpiBase;
import com.pi4j.io.spi.SpiConfig;
import com.pi4j.io.spi.SpiProvider;
import com.pi4j.util.StringUtil;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockSpi
extends SpiBase
implements Spi {
    private static final Logger logger = LoggerFactory.getLogger(MockSpi.class);
    private final String logPreamble;
    protected ArrayDeque<Byte> raw = new ArrayDeque();

    public MockSpi(SpiProvider provider, SpiConfig config) {
        super(provider, config);
        this.logPreamble = "[Mock SPI Provider::" + this.id + "] ::";
        logger.info("{} OPEN(CHANNEL={}; BAUD={})", this.logPreamble, config.address(), config.baud());
    }

    public byte[] readEntireMockBuffer() {
        byte[] bytes = new byte[this.raw.size()];
        int i = 0;
        while (!this.raw.isEmpty()) {
            bytes[i] = this.raw.pop();
            ++i;
        }
        logger.info("{} READALL (0x{})", (Object)this.logPreamble, (Object)StringUtil.toHexString(bytes));
        return bytes;
    }

    @Override
    public void close() {
        logger.info("{} CLOSE(CHANNEL={}; BAUD={})", this.logPreamble, ((SpiConfig)this.config).address(), ((SpiConfig)this.config).baud());
        super.close();
    }

    @Override
    public int transfer(byte[] write, int writeOffset, byte[] read, int readOffset, int numberOfBytes) {
        byte[] prepared = new byte[numberOfBytes];
        this.readNoLogging(prepared, 0, numberOfBytes);
        this.writeNoLogging(write, writeOffset, numberOfBytes);
        int offsetIndex = readOffset;
        for (byte preparedByte : prepared) {
            read[offsetIndex++] = preparedByte;
        }
        logger.info("{} TRANSFER(READ(0x{}), WRITE(0x{})", this.logPreamble, StringUtil.toHexString(prepared), StringUtil.toHexString(write, writeOffset, numberOfBytes));
        return 0;
    }

    @Override
    public int write(byte b) {
        this.raw.add(b);
        logger.info("{} WRITE(0x{})", (Object)this.logPreamble, (Object)StringUtil.toHexString(b));
        return 0;
    }

    @Override
    public int write(byte[] data, int offset, int length) {
        this.writeNoLogging(data, offset, length);
        logger.info("{} WRITE(0x{})", (Object)this.logPreamble, (Object)StringUtil.toHexString(data, offset, length));
        return length;
    }

    private void writeNoLogging(byte[] data, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, data.length);
        int p = offset;
        while (p - offset < length) {
            this.raw.add(data[p]);
            ++p;
        }
    }

    @Override
    public int write(Charset charset, CharSequence data) {
        byte[] buffer = data.toString().getBytes(charset);
        for (int p = 0; p < buffer.length; ++p) {
            this.raw.add(buffer[p]);
        }
        logger.info("{} WRITE(\"{}\")", (Object)this.logPreamble, (Object)data);
        return data.length();
    }

    @Override
    public int read() {
        if (this.raw.isEmpty()) {
            return -1;
        }
        byte b = this.raw.pop();
        logger.info("{} READ (0x{})", (Object)this.logPreamble, (Object)StringUtil.toHexString(b));
        return b;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) {
        Integer counter = this.readNoLogging(buffer, offset, length);
        if (counter == null) {
            return -1;
        }
        logger.info("{} READ (0x{})", (Object)this.logPreamble, (Object)StringUtil.toHexString(buffer, offset, length));
        return counter;
    }

    private Integer readNoLogging(byte[] buffer, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, buffer.length);
        if (this.raw.isEmpty()) {
            return null;
        }
        int counter = 0;
        for (int p = 0; p < length && p + offset <= buffer.length && !this.raw.isEmpty(); ++p) {
            buffer[offset + p] = this.raw.pop();
            ++counter;
        }
        return counter;
    }
}

