/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.pigpio.provider.gpio.digital;

import com.pi4j.context.Context;
import com.pi4j.exception.InitializeException;
import com.pi4j.exception.ShutdownException;
import com.pi4j.io.gpio.digital.DigitalInput;
import com.pi4j.io.gpio.digital.DigitalInputBase;
import com.pi4j.io.gpio.digital.DigitalInputConfig;
import com.pi4j.io.gpio.digital.DigitalInputProvider;
import com.pi4j.io.gpio.digital.DigitalState;
import com.pi4j.io.gpio.digital.DigitalStateChangeEvent;
import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.library.pigpio.PiGpioMode;
import com.pi4j.library.pigpio.PiGpioPud;
import com.pi4j.library.pigpio.PiGpioStateChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PiGpioDigitalInput
extends DigitalInputBase
implements DigitalInput {
    private final PiGpio piGpio;
    private final int pin;
    private DigitalState state = DigitalState.LOW;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private PiGpioStateChangeListener piGpioPinListener = event -> this.dispatch(new DigitalStateChangeEvent<PiGpioDigitalInput>(this, DigitalState.getState(event.state().value())));

    public PiGpioDigitalInput(PiGpio piGpio, DigitalInputProvider provider, DigitalInputConfig config) {
        super(provider, config);
        this.piGpio = piGpio;
        this.pin = config.address();
    }

    @Override
    public DigitalInput initialize(Context context) throws InitializeException {
        super.initialize(context);
        this.piGpio.gpioSetMode(this.pin, PiGpioMode.INPUT);
        switch (((DigitalInputConfig)this.config).pull()) {
            case PULL_DOWN: {
                this.piGpio.gpioSetPullUpDown(this.pin, PiGpioPud.DOWN);
                break;
            }
            case PULL_UP: {
                this.piGpio.gpioSetPullUpDown(this.pin, PiGpioPud.UP);
            }
        }
        if (((DigitalInputConfig)this.config).debounce() != null) {
            int steadyInterval = 0;
            steadyInterval = ((DigitalInputConfig)this.config).debounce() > 300000L ? 300000 : ((DigitalInputConfig)this.config).debounce().intValue();
            this.piGpio.gpioNoiseFilter(this.pin, 0, 0);
            this.piGpio.gpioGlitchFilter(this.pin, steadyInterval);
        }
        this.piGpio.addPinListener(this.pin, this.piGpioPinListener);
        return this;
    }

    @Override
    public DigitalState state() {
        try {
            switch (this.piGpio.gpioRead(this.pin)) {
                case LOW: {
                    this.state = DigitalState.LOW;
                    break;
                }
                case HIGH: {
                    this.state = DigitalState.HIGH;
                    break;
                }
                default: {
                    this.state = DigitalState.UNKNOWN;
                }
            }
            return this.state;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            return DigitalState.UNKNOWN;
        }
    }

    @Override
    public DigitalInput shutdown(Context context) throws ShutdownException {
        this.piGpio.removePinListener(this.pin, this.piGpioPinListener);
        return (DigitalInput)super.shutdown(context);
    }
}

