/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.pigpio.provider.gpio.digital;

import com.pi4j.boardinfo.util.BoardInfoHelper;
import com.pi4j.io.gpio.digital.DigitalInput;
import com.pi4j.io.gpio.digital.DigitalInputConfig;
import com.pi4j.io.gpio.digital.DigitalInputProviderBase;
import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalInput;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalInputProvider;

public class PiGpioDigitalInputProviderImpl
extends DigitalInputProviderBase
implements PiGpioDigitalInputProvider {
    protected final PiGpio piGpio;

    public PiGpioDigitalInputProviderImpl(PiGpio piGpio) {
        this.id = "pigpio-digital-input";
        this.name = "PiGpio Digital Input (GPIO) Provider";
        this.piGpio = piGpio;
    }

    @Override
    public int getPriority() {
        return BoardInfoHelper.usesRP1() ? 50 : 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DigitalInput create(DigitalInputConfig config) {
        PiGpio piGpio = this.piGpio;
        synchronized (piGpio) {
            if (!this.piGpio.isInitialized()) {
                this.piGpio.initialize();
            }
            PiGpioDigitalInput digitalInput = new PiGpioDigitalInput(this.piGpio, this, config);
            this.context.registry().add(digitalInput);
            return digitalInput;
        }
    }
}

