/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.pigpio.provider.gpio.digital;

import com.pi4j.boardinfo.util.BoardInfoHelper;
import com.pi4j.io.gpio.digital.DigitalOutput;
import com.pi4j.io.gpio.digital.DigitalOutputConfig;
import com.pi4j.io.gpio.digital.DigitalOutputProviderBase;
import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalOutput;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalOutputProvider;

public class PiGpioDigitalOutputProviderImpl
extends DigitalOutputProviderBase
implements PiGpioDigitalOutputProvider {
    protected final PiGpio piGpio;

    public PiGpioDigitalOutputProviderImpl(PiGpio piGpio) {
        this.id = "pigpio-digital-output";
        this.name = "PiGpio Digital Output (GPIO) Provider";
        this.piGpio = piGpio;
    }

    @Override
    public int getPriority() {
        return BoardInfoHelper.usesRP1() ? 50 : 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DigitalOutput create(DigitalOutputConfig config) {
        PiGpio piGpio = this.piGpio;
        synchronized (piGpio) {
            if (!this.piGpio.isInitialized()) {
                this.piGpio.initialize();
            }
            PiGpioDigitalOutput digitalOutput = new PiGpioDigitalOutput(this.piGpio, this, config);
            this.context.registry().add(digitalOutput);
            return digitalOutput;
        }
    }
}

