/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.pigpio.provider.i2c;

import com.pi4j.context.Context;
import com.pi4j.exception.InitializeException;
import com.pi4j.io.i2c.I2C;
import com.pi4j.io.i2c.I2CBase;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.io.i2c.I2CProvider;
import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.library.pigpio.PiGpioMode;
import com.pi4j.plugin.pigpio.provider.i2c.PiGpioI2CBus;
import java.util.Objects;

public class PiGpioI2C
extends I2CBase<PiGpioI2CBus>
implements I2C {
    protected final PiGpio piGpio;
    protected final int handle;

    public PiGpioI2C(PiGpio piGpio, PiGpioI2CBus i2CBus, I2CProvider provider, I2CConfig config) {
        super(provider, config, i2CBus);
        this.piGpio = piGpio;
        switch (config.bus()) {
            case 0: {
                piGpio.gpioSetMode(0, PiGpioMode.ALT0);
                piGpio.gpioSetMode(1, PiGpioMode.ALT0);
                break;
            }
            case 1: {
                piGpio.gpioSetMode(2, PiGpioMode.ALT0);
                piGpio.gpioSetMode(3, PiGpioMode.ALT0);
            }
        }
        this.handle = piGpio.i2cOpen(config.bus(), config.device());
        this.isOpen = true;
    }

    @Override
    public I2C initialize(Context context) throws InitializeException {
        super.initialize(context);
        return this;
    }

    @Override
    public void close() {
        this.piGpio.i2cClose(this.handle);
        super.close();
    }

    @Override
    public int write(byte b) {
        return this.piGpio.i2cWriteByte(this.handle, b);
    }

    @Override
    public int write(byte[] data, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, data.length);
        this.piGpio.i2cWriteDevice(this.handle, data, offset, length);
        return length;
    }

    @Override
    public int read() {
        return this.piGpio.i2cReadByte(this.handle);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, buffer.length);
        return this.piGpio.i2cReadDevice(this.handle, buffer, offset, length);
    }

    @Override
    public int writeRegister(int register, byte b) {
        return this.piGpio.i2cWriteByteData(this.handle, register, b);
    }

    @Override
    public int writeRegister(int register, byte[] data, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, data.length);
        this.piGpio.i2cWriteI2CBlockData(this.handle, register, data, offset, length);
        return length;
    }

    @Override
    public int writeRegister(byte[] register, byte[] data, int offset, int length) {
        throw new IllegalStateException("Not supported, please use LinuxFS plugin");
    }

    @Override
    public int readRegister(int register) {
        return this.piGpio.i2cReadByteData(this.handle, register);
    }

    @Override
    public int readRegister(byte[] register, byte[] buffer, int offset, int length) {
        throw new IllegalStateException("Not supported, please use LinuxFS plugin");
    }

    @Override
    public int readRegister(int register, byte[] buffer, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, buffer.length);
        return this.piGpio.i2cReadI2CBlockData(this.handle, register, buffer, offset, length);
    }

    @Override
    public int writeReadRegisterWord(int register, int word) {
        return this.piGpio.i2cProcessCall(this.handle, register, word);
    }
}

