/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.pigpio.provider.pwm;

import com.pi4j.context.Context;
import com.pi4j.exception.InitializeException;
import com.pi4j.io.exception.IOException;
import com.pi4j.io.pwm.Pwm;
import com.pi4j.io.pwm.PwmConfig;
import com.pi4j.io.pwm.PwmPolarity;
import com.pi4j.io.pwm.PwmProvider;
import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.library.pigpio.PiGpioMode;
import com.pi4j.plugin.pigpio.provider.pwm.PiGpioPwmBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PiGpioPwmHardware
extends PiGpioPwmBase
implements Pwm {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean initializing = false;
    public static int RANGE = 1000000;

    public PiGpioPwmHardware(PiGpio piGpio, PwmProvider provider, PwmConfig config) {
        super(piGpio, provider, config, RANGE);
    }

    @Override
    public Pwm initialize(Context context) throws InitializeException {
        try {
            this.initializing = true;
            if (this.address() == 12 || this.address() == 13 || this.address() == 41 || this.address() == 42 || this.address() == 45) {
                this.piGpio.gpioSetMode(this.address(), PiGpioMode.ALT0);
            } else if (this.address() == 18 || this.address() == 19) {
                this.piGpio.gpioSetMode(this.address(), PiGpioMode.ALT0);
            }
            if (((PwmConfig)this.config).polarity() != null && ((PwmConfig)this.config).polarity() == PwmPolarity.INVERSED) {
                throw new IOException("<PIGPIO> INVERSED POLARITY UNSUPPORTED; PWM PIN: " + this.address());
            }
            this.piGpio.gpioSetMode(this.address(), PiGpioMode.OUTPUT);
            this.actualFrequency = this.piGpio.gpioGetPWMfrequency(this.address());
            this.frequency = ((PwmConfig)this.config).frequency() != null ? ((PwmConfig)this.config).frequency() : this.actualFrequency;
            this.dutyCycle = ((PwmConfig)this.config).dutyCycle() != null ? ((PwmConfig)this.config).dutyCycle().floatValue() : 50.0f;
            if (((PwmConfig)this.config).initialValue() != null) {
                try {
                    if (((PwmConfig)this.config).initialValue().floatValue() <= 0.0f) {
                        this.off();
                    } else {
                        this.on(((PwmConfig)this.config).initialValue());
                    }
                }
                catch (IOException e) {
                    throw new InitializeException(e);
                }
            }
            this.initializing = false;
        }
        catch (Exception e) {
            this.initializing = false;
            throw new InitializeException(e);
        }
        return this;
    }

    @Override
    public Pwm on() throws IOException {
        try {
            this.piGpio.gpioHardwarePWM(this.address(), this.frequency, this.calculateActualDutyCycle(this.dutyCycle));
            this.actualFrequency = this.piGpio.gpioGetPWMfrequency(this.address());
            this.onState = this.frequency > 0 && this.dutyCycle > 0.0f;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            throw new IOException(e);
        }
        return this;
    }

    @Override
    public Pwm off() throws IOException {
        try {
            if (this.initializing) {
                this.piGpio.gpioHardwarePWM(this.address(), 1, 1);
            }
            this.piGpio.gpioHardwarePWM(this.address(), 0, 0);
            this.onState = false;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            throw new IOException(e);
        }
        return this;
    }
}

