/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.pigpio.provider.pwm;

import com.pi4j.boardinfo.util.BoardInfoHelper;
import com.pi4j.io.pwm.Pwm;
import com.pi4j.io.pwm.PwmConfig;
import com.pi4j.io.pwm.PwmProviderBase;
import com.pi4j.io.pwm.PwmType;
import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.plugin.pigpio.provider.pwm.PiGpioPwmBase;
import com.pi4j.plugin.pigpio.provider.pwm.PiGpioPwmHardware;
import com.pi4j.plugin.pigpio.provider.pwm.PiGpioPwmProvider;
import com.pi4j.plugin.pigpio.provider.pwm.PiGpioPwmSoftware;

public class PiGpioPwmProviderImpl
extends PwmProviderBase
implements PiGpioPwmProvider {
    final PiGpio piGpio;

    public PiGpioPwmProviderImpl(PiGpio piGpio) {
        this.id = "pigpio-pwm";
        this.name = "PiGpio PWM Provider";
        this.piGpio = piGpio;
    }

    @Override
    public int getPriority() {
        return BoardInfoHelper.usesRP1() ? 50 : 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pwm create(PwmConfig config) {
        PiGpio piGpio = this.piGpio;
        synchronized (piGpio) {
            if (!this.piGpio.isInitialized()) {
                this.piGpio.initialize();
            }
            PiGpioPwmBase pwm = config.pwmType() == PwmType.HARDWARE ? new PiGpioPwmHardware(this.piGpio, this, config) : new PiGpioPwmSoftware(this.piGpio, this, config);
            this.context.registry().add(pwm);
            return pwm;
        }
    }
}

