/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.plugin.pigpio.provider.pwm;

import com.pi4j.context.Context;
import com.pi4j.exception.InitializeException;
import com.pi4j.io.exception.IOException;
import com.pi4j.io.pwm.Pwm;
import com.pi4j.io.pwm.PwmConfig;
import com.pi4j.io.pwm.PwmPolarity;
import com.pi4j.io.pwm.PwmProvider;
import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.library.pigpio.PiGpioMode;
import com.pi4j.plugin.pigpio.provider.pwm.PiGpioPwmBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PiGpioPwmSoftware
extends PiGpioPwmBase
implements Pwm {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    public static int RANGE = 255;

    public PiGpioPwmSoftware(PiGpio piGpio, PwmProvider provider, PwmConfig config) {
        super(piGpio, provider, config, RANGE);
    }

    @Override
    public Pwm initialize(Context context) throws InitializeException {
        block7: {
            try {
                if (((PwmConfig)this.config).polarity() != null && ((PwmConfig)this.config).polarity() == PwmPolarity.INVERSED) {
                    throw new IOException("<PIGPIO> INVERSED POLARITY UNSUPPORTED; PWM PIN: " + this.address());
                }
                this.piGpio.gpioSetMode(this.address(), PiGpioMode.OUTPUT);
                this.piGpio.gpioSetPWMrange(this.address(), RANGE);
                this.actualFrequency = this.piGpio.gpioGetPWMfrequency(this.address());
                this.frequency = ((PwmConfig)this.config).frequency() != null ? ((PwmConfig)this.config).frequency() : this.actualFrequency;
                this.dutyCycle = ((PwmConfig)this.config).dutyCycle() != null ? ((PwmConfig)this.config).dutyCycle().floatValue() : 50.0f;
                if (((PwmConfig)this.config).initialValue() == null) break block7;
                try {
                    if (((PwmConfig)this.config).initialValue().floatValue() <= 0.0f) {
                        this.off();
                    } else {
                        this.on(((PwmConfig)this.config).initialValue());
                    }
                }
                catch (IOException e) {
                    throw new InitializeException(e);
                }
            }
            catch (Exception e) {
                throw new InitializeException(e);
            }
        }
        return this;
    }

    @Override
    public Pwm on() throws IOException {
        try {
            this.actualFrequency = this.piGpio.gpioSetPWMfrequency(this.address(), this.frequency);
            this.piGpio.gpioPWM(this.address(), this.calculateActualDutyCycle(this.dutyCycle));
            this.onState = this.frequency > 0 && this.dutyCycle > 0.0f;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            throw new IOException(e);
        }
        return this;
    }

    @Override
    public Pwm off() throws IOException {
        try {
            this.piGpio.gpioPWM(this.address(), 0);
            this.onState = false;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            throw new IOException(e);
        }
        return this;
    }
}

