/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.provider;

import com.pi4j.common.Describable;
import com.pi4j.common.Descriptor;
import com.pi4j.io.IOType;
import com.pi4j.provider.Provider;
import com.pi4j.provider.Providers;
import com.pi4j.provider.exception.ProviderException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderGroup<T extends Provider>
implements Describable {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private IOType type = null;
    private Providers providers;

    public ProviderGroup(Providers providers, IOType type) {
        this.providers = providers;
        this.type = type;
    }

    private Map<String, T> all() throws ProviderException {
        return this.providers.all(this.type);
    }

    public T get(String providerId) throws ProviderException {
        return this.providers.get(providerId, this.type);
    }

    public boolean exists(String providerId) throws ProviderException {
        return this.providers.exists(providerId, this.type);
    }

    @Override
    public Descriptor describe() {
        Descriptor descriptor = Descriptor.create().category("PROVIDER GROUP").name("Provider Group").type(this.getClass());
        Map<String, T> all = null;
        try {
            all = this.all();
            all.forEach((id, provider) -> descriptor.add(provider.describe()));
        }
        catch (ProviderException e) {
            this.logger.error(e.getMessage(), e);
        }
        return descriptor;
    }
}

