/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.provider;

import com.pi4j.common.Describable;
import com.pi4j.common.Descriptor;
import com.pi4j.io.IOType;
import com.pi4j.io.gpio.analog.AnalogInputProvider;
import com.pi4j.io.gpio.analog.AnalogOutputProvider;
import com.pi4j.io.gpio.digital.DigitalInputProvider;
import com.pi4j.io.gpio.digital.DigitalOutputProvider;
import com.pi4j.io.i2c.I2CProvider;
import com.pi4j.io.pwm.PwmProvider;
import com.pi4j.io.serial.SerialProvider;
import com.pi4j.io.spi.SpiProvider;
import com.pi4j.provider.Provider;
import com.pi4j.provider.ProviderGroup;
import com.pi4j.provider.exception.ProviderException;
import com.pi4j.provider.exception.ProviderIOTypeException;
import com.pi4j.provider.exception.ProviderNotFoundException;
import com.pi4j.provider.exception.ProviderTypeException;
import java.util.Map;
import org.slf4j.LoggerFactory;

public interface Providers
extends Describable {
    public ProviderGroup<AnalogInputProvider> analogInput();

    public ProviderGroup<AnalogOutputProvider> analogOutput();

    public ProviderGroup<DigitalInputProvider> digitalInput();

    public ProviderGroup<DigitalOutputProvider> digitalOutput();

    public ProviderGroup<PwmProvider> pwm();

    public ProviderGroup<SpiProvider> spi();

    public ProviderGroup<I2CProvider> i2c();

    public ProviderGroup<SerialProvider> serial();

    public Map<String, Provider> all();

    public <T extends Provider> Map<String, T> all(Class<T> var1) throws ProviderNotFoundException;

    public <T extends Provider> Map<String, T> all(IOType var1) throws ProviderNotFoundException;

    public boolean exists(String var1);

    default public <T extends Provider> boolean exists(String providerId, Class<T> providerClass) {
        try {
            return this.get(providerId, providerClass) != null;
        }
        catch (ProviderException e) {
            return false;
        }
    }

    default public <T extends Provider> boolean exists(String providerId, IOType ioType) {
        try {
            return this.get(providerId, ioType) != null;
        }
        catch (ProviderException e) {
            return false;
        }
    }

    default public <T extends Provider> boolean exists(IOType ioType) {
        try {
            return !this.all(ioType).isEmpty();
        }
        catch (ProviderNotFoundException e) {
            return false;
        }
    }

    default public <T extends Provider> boolean exists(Class<T> providerClass) {
        try {
            return !this.all(providerClass).isEmpty();
        }
        catch (ProviderNotFoundException e) {
            return false;
        }
    }

    public <T extends Provider> T get(String var1) throws ProviderNotFoundException;

    default public <T extends Provider> T get(String providerId, Class<T> providerClass) throws ProviderNotFoundException, ProviderTypeException {
        T provider = this.get(providerId);
        if (providerClass.isAssignableFrom(provider.getClass())) {
            return provider;
        }
        throw new ProviderTypeException((Provider)provider, (Class<? extends Provider>)providerClass);
    }

    default public <T extends Provider> T get(String providerId, IOType ioType) throws ProviderNotFoundException, ProviderIOTypeException {
        T provider = this.get(providerId);
        if (provider.getType().isType(ioType)) {
            return provider;
        }
        throw new ProviderIOTypeException((Provider)provider, ioType);
    }

    default public <T extends Provider> T get(Class<T> providerClass) throws ProviderNotFoundException {
        Map<String, T> subset = this.all(providerClass);
        if (subset.isEmpty()) {
            throw new ProviderNotFoundException(providerClass);
        }
        return (T)((Provider)subset.values().iterator().next());
    }

    default public <T extends Provider> T get(IOType ioType) throws ProviderNotFoundException {
        Map<String, T> subset = this.all(ioType);
        if (subset.isEmpty()) {
            throw new ProviderNotFoundException(ioType);
        }
        return (T)((Provider)subset.values().iterator().next());
    }

    default public ProviderGroup<AnalogInputProvider> getAnalogInputProviders() {
        return this.analogInput();
    }

    default public ProviderGroup<AnalogOutputProvider> getAnalogOutputProviders() {
        return this.analogOutput();
    }

    default public ProviderGroup<DigitalInputProvider> getDigitalInputProviders() {
        return this.digitalInput();
    }

    default public ProviderGroup<DigitalOutputProvider> getDigitalOutputProviders() {
        return this.digitalOutput();
    }

    default public ProviderGroup<PwmProvider> getPwmProviders() {
        return this.pwm();
    }

    default public ProviderGroup<SpiProvider> getSpiProviders() {
        return this.spi();
    }

    default public ProviderGroup<I2CProvider> getI2CProviders() {
        return this.i2c();
    }

    default public ProviderGroup<SerialProvider> getSerialProviders() {
        return this.serial();
    }

    default public Map<String, Provider> getAll() {
        return this.all();
    }

    default public <T extends Provider> Map<String, T> getAll(Class<T> providerClass) throws ProviderNotFoundException {
        return this.all(providerClass);
    }

    default public <T extends Provider> Map<String, T> getAll(IOType ioType) throws ProviderNotFoundException {
        return this.all(ioType);
    }

    @Override
    default public Descriptor describe() {
        Map<String, Provider> providers = this.all();
        Descriptor descriptor = Descriptor.create().category("PROVIDERS").name("I/O Providers").quantity(providers == null ? 0 : providers.size()).type(this.getClass());
        for (IOType ioType : IOType.values()) {
            try {
                Map providersByType = this.getAll(ioType);
                Descriptor ioTypeDescriptor = Descriptor.create().category(ioType.name()).quantity(providers == null ? 0 : providersByType.size()).type(ioType.getProviderClass());
                if (providersByType != null && !providersByType.isEmpty()) {
                    providersByType.forEach((id, provider) -> ioTypeDescriptor.add(provider.describe()));
                }
                descriptor.add(ioTypeDescriptor);
            }
            catch (ProviderNotFoundException e) {
                LoggerFactory.getLogger(this.getClass()).error(e.getMessage(), e);
            }
        }
        return descriptor;
    }
}

