/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.provider.impl;

import com.pi4j.exception.InitializeException;
import com.pi4j.exception.Pi4JException;
import com.pi4j.exception.ShutdownException;
import com.pi4j.io.IOType;
import com.pi4j.io.gpio.analog.AnalogInputProvider;
import com.pi4j.io.gpio.analog.AnalogOutputProvider;
import com.pi4j.io.gpio.digital.DigitalInputProvider;
import com.pi4j.io.gpio.digital.DigitalOutputProvider;
import com.pi4j.io.i2c.I2CProvider;
import com.pi4j.io.pwm.PwmProvider;
import com.pi4j.io.serial.SerialProvider;
import com.pi4j.io.spi.SpiProvider;
import com.pi4j.provider.Provider;
import com.pi4j.provider.ProviderGroup;
import com.pi4j.provider.Providers;
import com.pi4j.provider.exception.ProviderAlreadyExistsException;
import com.pi4j.provider.exception.ProviderInitializeException;
import com.pi4j.provider.exception.ProviderNotFoundException;
import com.pi4j.provider.impl.RuntimeProviders;
import com.pi4j.runtime.Runtime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRuntimeProviders
implements RuntimeProviders {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRuntimeProviders.class);
    private Runtime runtime = null;
    private Map<String, Provider> providers = new ConcurrentHashMap<String, Provider>();
    private ProviderGroup<AnalogInputProvider> _analogInput = new ProviderGroup(this, IOType.ANALOG_INPUT);
    private ProviderGroup<AnalogOutputProvider> _analogOutput = new ProviderGroup(this, IOType.ANALOG_OUTPUT);
    private ProviderGroup<DigitalInputProvider> _digitalInput = new ProviderGroup(this, IOType.DIGITAL_INPUT);
    private ProviderGroup<DigitalOutputProvider> _digitalOutput = new ProviderGroup(this, IOType.DIGITAL_OUTPUT);
    private ProviderGroup<PwmProvider> _pwm = new ProviderGroup(this, IOType.PWM);
    private ProviderGroup<SpiProvider> _spi = new ProviderGroup(this, IOType.SPI);
    private ProviderGroup<I2CProvider> _i2c = new ProviderGroup(this, IOType.I2C);
    private ProviderGroup<SerialProvider> _serial = new ProviderGroup(this, IOType.SERIAL);

    @Override
    public ProviderGroup<AnalogInputProvider> analogInput() {
        return this._analogInput;
    }

    @Override
    public ProviderGroup<AnalogOutputProvider> analogOutput() {
        return this._analogOutput;
    }

    @Override
    public ProviderGroup<DigitalInputProvider> digitalInput() {
        return this._digitalInput;
    }

    @Override
    public ProviderGroup<DigitalOutputProvider> digitalOutput() {
        return this._digitalOutput;
    }

    @Override
    public ProviderGroup<PwmProvider> pwm() {
        return this._pwm;
    }

    @Override
    public ProviderGroup<SpiProvider> spi() {
        return this._spi;
    }

    @Override
    public ProviderGroup<I2CProvider> i2c() {
        return this._i2c;
    }

    @Override
    public ProviderGroup<SerialProvider> serial() {
        return this._serial;
    }

    public static RuntimeProviders newInstance(Runtime runtime) {
        return new DefaultRuntimeProviders(runtime);
    }

    private DefaultRuntimeProviders(Runtime runtime) {
        this.runtime = runtime;
    }

    @Override
    public Map<String, Provider> all() {
        return Collections.unmodifiableMap(this.providers);
    }

    @Override
    public <T extends Provider> Map<String, T> all(Class<T> providerClass) {
        if (!providerClass.isInterface()) {
            logger.warn("Provider type [" + providerClass.getName() + "] requested; this is not an 'Interface' and make not return a valid provider or may not be able to cast to the concrete class.");
        }
        ConcurrentHashMap result = new ConcurrentHashMap();
        this.providers.values().stream().forEach(p -> {
            if (providerClass.isInstance(p)) {
                result.put(p.id(), p);
            }
        });
        return Collections.unmodifiableMap(result);
    }

    @Override
    public <T extends Provider> Map<String, T> all(IOType ioType) {
        ConcurrentHashMap result = new ConcurrentHashMap();
        this.providers.values().stream().filter(provider -> provider.isType(ioType)).forEach(provider -> result.put(provider.id(), provider));
        return Collections.unmodifiableMap(result);
    }

    @Override
    public boolean exists(String providerId) {
        if (this.providers.containsKey(providerId)) {
            return true;
        }
        try {
            Class<?> providerClass = Class.forName(providerId);
            if (providerClass != null && Provider.class.isAssignableFrom(providerClass)) {
                for (Provider provider : this.providers.values()) {
                    if (!providerClass.isInstance(provider)) continue;
                    return true;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public Provider get(String providerId) throws ProviderNotFoundException {
        if (this.providers.containsKey(providerId)) {
            return this.providers.get(providerId);
        }
        try {
            Class<?> providerClass = Class.forName(providerId);
            if (providerClass != null && Provider.class.isAssignableFrom(providerClass)) {
                for (Provider provider : this.providers.values()) {
                    if (!providerClass.isInstance(provider)) continue;
                    return provider;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new ProviderNotFoundException(providerId);
    }

    private <T extends Provider> Providers add(T ... provider) throws ProviderInitializeException, ProviderAlreadyExistsException {
        return this.add((Collection<T>)Arrays.asList(provider));
    }

    private <T extends Provider> Providers add(Collection<T> provider) throws ProviderAlreadyExistsException, ProviderInitializeException {
        logger.trace("invoked 'add()' provider [count={}]", (Object)provider.size());
        for (Provider providerInstance : provider) {
            if (providerInstance == null) continue;
            logger.trace("adding provider to managed io map [id={}; name={}; class={}]", providerInstance.id(), providerInstance.name(), providerInstance.getClass().getName());
            if (this.exists(providerInstance.id())) {
                throw new ProviderAlreadyExistsException(providerInstance.id());
            }
            this.initializeProvider(providerInstance);
            this.providers.put(providerInstance.id(), providerInstance);
            logger.debug("added io to managed provider map [id={}; name={}; class={}]", providerInstance.id(), providerInstance.name(), providerInstance.getClass().getName());
        }
        return this;
    }

    private void initializeProvider(Provider provider) throws ProviderInitializeException {
        if (provider == null) {
            return;
        }
        try {
            logger.trace("initializing provider [id={}; name={}; class={}]", provider.id(), provider.name(), provider.getClass().getName());
            provider.initialize(this.runtime.context());
        }
        catch (Exception e) {
            logger.error("unable to 'initialize()' provider: [id={}; name={}]; {}", provider.id(), provider.name(), e.getMessage());
            logger.error(e.getMessage(), e);
            throw new ProviderInitializeException(provider.id(), (Throwable)e);
        }
    }

    private void shutdownProvider(Provider provider) throws ShutdownException {
        if (provider == null) {
            return;
        }
        try {
            logger.trace("calling 'shutdown()' provider [id={}; name={}; class={}]", provider.id(), provider.name(), provider.getClass().getName());
            provider.shutdown(this.runtime.context());
        }
        catch (ShutdownException e) {
            logger.error("unable to 'shutdown()' provider: [id={}; name={}]; {}", provider.id(), provider.name(), e.getMessage());
            logger.error(e.getMessage(), e);
            throw e;
        }
    }

    private <T extends Provider> void remove(String providerId) throws ProviderNotFoundException, ShutdownException {
        logger.trace("invoked 'remove() provider' [id={}]", (Object)providerId);
        Provider oldProvider = this.get(providerId);
        this.shutdownProvider(oldProvider);
        Provider removedProvider = this.providers.remove(providerId);
        if (removedProvider != null) {
            logger.debug("removed provider from managed provider map [id={}; name={}; class={}]", removedProvider.id(), removedProvider.name(), removedProvider.getClass().getName());
        }
    }

    @Override
    public RuntimeProviders shutdown() throws ShutdownException {
        logger.trace("invoked providers 'shutdown();'");
        ShutdownException shutdownException = null;
        Set<String> providerIds = this.providers.keySet();
        for (String providerId : providerIds) {
            try {
                this.remove(providerId);
            }
            catch (Pi4JException e) {
                shutdownException = new ShutdownException(e);
            }
        }
        this.providers.clear();
        if (shutdownException != null) {
            throw shutdownException;
        }
        return this;
    }

    @Override
    public RuntimeProviders initialize(Collection<Provider> providers) throws InitializeException {
        if (providers != null && !providers.isEmpty()) {
            logger.trace("adding providers: [count={}]", (Object)providers.size());
            for (Provider provider : providers) {
                if (provider == null) continue;
                logger.trace("adding provider: [id={}; name={}; class={}]", provider.id(), provider.name(), provider.getClass().getName());
                try {
                    this.add(new Provider[]{provider});
                }
                catch (Exception ex) {
                    logger.error("unable to 'initialize()' provider: [id={}; name={}]; {}", provider.id(), provider.name(), ex.getMessage());
                }
            }
        }
        logger.debug("providers loaded [{}]", (Object)this.providers.size());
        return this;
    }
}

