/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.runtime.impl;

import com.pi4j.context.Context;
import com.pi4j.context.ContextConfig;
import com.pi4j.event.EventManager;
import com.pi4j.event.InitializedEvent;
import com.pi4j.event.InitializedListener;
import com.pi4j.event.ShutdownEvent;
import com.pi4j.event.ShutdownListener;
import com.pi4j.exception.InitializeException;
import com.pi4j.exception.ShutdownException;
import com.pi4j.extension.Plugin;
import com.pi4j.extension.impl.DefaultPluginService;
import com.pi4j.extension.impl.PluginStore;
import com.pi4j.io.IOType;
import com.pi4j.platform.Platform;
import com.pi4j.platform.impl.DefaultRuntimePlatforms;
import com.pi4j.platform.impl.RuntimePlatforms;
import com.pi4j.provider.Provider;
import com.pi4j.provider.impl.DefaultRuntimeProviders;
import com.pi4j.provider.impl.RuntimeProviders;
import com.pi4j.registry.impl.DefaultRuntimeRegistry;
import com.pi4j.registry.impl.RuntimeRegistry;
import com.pi4j.runtime.Runtime;
import com.pi4j.runtime.RuntimeProperties;
import com.pi4j.runtime.impl.DefaultRuntimeProperties;
import com.pi4j.util.ExecutorPool;
import com.pi4j.util.PropertiesUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRuntime
implements Runtime {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Context context;
    private final RuntimeRegistry registry;
    private final RuntimeProviders providers;
    private final RuntimePlatforms platforms;
    private final RuntimeProperties properties;
    private final List<Plugin> plugins;
    private boolean isShutdown = false;
    private final EventManager<Runtime, ShutdownListener, ShutdownEvent> shutdownEventManager;
    private final EventManager<Runtime, InitializedListener, InitializedEvent> initializedEventManager;
    private final ExecutorPool executorPool;
    private final ExecutorService runtimeExecutor;

    public static Runtime newInstance(Context context) {
        return new DefaultRuntime(context);
    }

    private DefaultRuntime(Context context) {
        this.context = context;
        this.plugins = new ArrayList<Plugin>();
        this.properties = DefaultRuntimeProperties.newInstance(context);
        this.registry = DefaultRuntimeRegistry.newInstance(this);
        this.providers = DefaultRuntimeProviders.newInstance(this);
        this.platforms = DefaultRuntimePlatforms.newInstance(this);
        this.shutdownEventManager = new EventManager<DefaultRuntime, ShutdownListener, ShutdownEvent>(this, (listener, event) -> listener.onShutdown((ShutdownEvent)event));
        this.initializedEventManager = new EventManager<DefaultRuntime, InitializedListener, InitializedEvent>(this, (listener, event) -> listener.onInitialized((InitializedEvent)event));
        this.executorPool = new ExecutorPool();
        this.runtimeExecutor = this.executorPool.getExecutor("Pi4J.RUNTIME");
        this.logger.debug("Pi4J runtime context successfully created & initialized.'");
        java.lang.Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                if (!this.isShutdown) {
                    this.shutdown();
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to shutdown Pi4J runtime", e);
            }
        }, "pi4j-shutdown"));
    }

    @Override
    public Context context() {
        return this.context;
    }

    @Override
    public RuntimeRegistry registry() {
        return this.registry;
    }

    @Override
    public RuntimeProviders providers() {
        return this.providers;
    }

    @Override
    public RuntimePlatforms platforms() {
        return this.platforms;
    }

    @Override
    public RuntimeProperties properties() {
        return this.properties;
    }

    @Override
    public Future<?> submitTask(Runnable task) {
        return this.runtimeExecutor.submit(task);
    }

    @Override
    public Runtime shutdown() throws ShutdownException {
        if (this.isShutdown) {
            this.logger.warn("Pi4J context/runtime is already shutdown.'");
            return this;
        }
        this.isShutdown = true;
        this.logger.info("Shutting down Pi4J context/runtime...");
        this.shutdownEventManager.dispatch(new ShutdownEvent(this.context), ShutdownListener::beforeShutdown);
        try {
            this.registry.shutdown();
            this.platforms.shutdown();
            this.providers.shutdown();
            for (Plugin plugin : this.plugins) {
                try {
                    plugin.shutdown(this.context);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), e);
                }
            }
            this.executorPool.destroy();
        }
        catch (Exception e) {
            this.logger.error("failed to 'shutdown(); '", e);
            throw new ShutdownException(e);
        }
        this.logger.info("Pi4J context/runtime successfully shutdown. Dispatching shutdown event.");
        this.shutdownEventManager.dispatch(new ShutdownEvent(this.context));
        this.shutdownEventManager.clear();
        return this;
    }

    @Override
    public Future<Context> asyncShutdown() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.shutdown();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), e);
            }
            return this.context;
        });
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Runtime initialize() throws InitializeException {
        this.logger.info("Initializing Pi4J context/runtime...");
        try {
            this.plugins.clear();
            HashSet<Platform> platforms = new HashSet<Platform>();
            HashMap providers = new HashMap();
            ContextConfig config = this.context.config();
            if (config.autoDetectPlatforms() || config.autoDetectProviders()) {
                ServiceLoader<Plugin> plugins = ServiceLoader.load(Plugin.class);
                for (Plugin plugin : plugins) {
                    if (plugin == null) continue;
                    if (!config.autoDetectMockPlugins() && plugin.isMock()) {
                        this.logger.trace("Ignoring mock plugin: [{}] in classpath", (Object)plugin.getClass().getName());
                        continue;
                    }
                    this.logger.trace("detected plugin: [{}] in classpath; calling 'initialize()'", (Object)plugin.getClass().getName());
                    try {
                        this.plugins.add(plugin);
                        PluginStore store = new PluginStore();
                        plugin.initialize(DefaultPluginService.newInstance(this.context(), store));
                        if (config.autoDetectProviders()) {
                            store.providers.forEach(provider -> this.addProvider((Provider)provider, providers));
                        }
                        if (!config.autoDetectPlatforms()) continue;
                        platforms.addAll(store.platforms);
                    }
                    catch (Exception ex) {
                        this.logger.error("unable to 'initialize()' plugin: [{}]; {}", plugin.getClass().getName(), ex.getMessage(), ex);
                    }
                }
            }
            platforms.addAll(this.context().config().getPlatforms());
            this.context().config().getProviders().forEach(provider -> {
                Provider replaced = providers.put(provider.getType(), provider);
                if (replaced != null) {
                    this.logger.warn("Replacing auto detected provider {} {} with provider {} from context config", new Object[]{replaced.getType(), replaced.getName(), provider.getName()});
                }
            });
            this.registry.initialize();
            this.providers.initialize(providers.values());
            this.platforms.initialize(platforms);
            try {
                if (this.context().config().autoInject()) {
                    Map<String, String> candidates = PropertiesUtil.keysEndsWith(this.context().properties().all(), "inject");
                    for (String candidateKey : candidates.keySet()) {
                        try {
                            boolean candidateInject = Boolean.parseBoolean(candidates.getOrDefault(candidateKey, "false"));
                            if (!candidateInject) continue;
                            this.context().create(candidateKey);
                        }
                        catch (Exception e) {
                            this.logger.error("FAILED TO AUTO-INJECT [{}]; {}'", candidateKey, e.getMessage(), e);
                            throw new InitializeException(e);
                        }
                    }
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), e);
            }
        }
        catch (Exception e) {
            this.logger.error("failed to 'initialize(); '", e);
            throw new InitializeException(e);
        }
        this.logger.info("Pi4J context/runtime successfully initialized.");
        this.notifyInitListeners();
        return this;
    }

    private void addProvider(Provider provider, Map<IOType, Provider> providers) {
        if (!providers.containsKey((Object)provider.getType())) {
            providers.put(provider.getType(), provider);
        } else {
            Provider existingProvider = providers.get((Object)provider.getType());
            if (provider.getPriority() <= existingProvider.getPriority()) {
                if (existingProvider.getName().equals(provider.getName())) {
                    throw new InitializeException(String.valueOf((Object)provider.getType()) + " with name " + provider.getName() + " is already registered.");
                }
                this.logger.warn("Ignoring provider {} {} with priority {} as lower priority than {} which has priority {}", new Object[]{provider.getType(), provider.getName(), provider.getPriority(), existingProvider.getName(), existingProvider.getPriority()});
            } else {
                this.logger.warn("Replacing provider {} {} with priority {} with provider {} with higher priority {}", new Object[]{existingProvider.getType(), existingProvider.getName(), existingProvider.getPriority(), provider.getName(), provider.getPriority()});
                providers.put(provider.getType(), provider);
            }
        }
    }

    private void notifyInitListeners() {
        this.initializedEventManager.dispatch(new InitializedEvent(this.context));
    }

    @Override
    public Runtime addListener(ShutdownListener ... listener) {
        return (Runtime)this.shutdownEventManager.add(listener);
    }

    @Override
    public Runtime removeListener(ShutdownListener ... listener) {
        return (Runtime)this.shutdownEventManager.remove(listener);
    }

    @Override
    public Runtime removeAllShutdownListeners() {
        return this.shutdownEventManager.clear();
    }

    @Override
    public Runtime removeAllInitializedListeners() {
        return this.initializedEventManager.clear();
    }

    @Override
    public Runtime addListener(InitializedListener ... listener) {
        return (Runtime)this.initializedEventManager.add(listener);
    }

    @Override
    public Runtime removeListener(InitializedListener ... listener) {
        return (Runtime)this.initializedEventManager.remove(listener);
    }
}

