/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.util;

public class Frequency {
    public static final long MEGAHERTZ = 1000000L;
    public static final long KILOHERTZ = 1000L;
    public static final long HERTZ = 1L;

    public static int kilohertz(Number frequency) {
        return Math.round(frequency.floatValue() * 1000.0f);
    }

    public static int megahertz(Number frequency) {
        return Math.round(frequency.floatValue() * 1000000.0f);
    }

    public static long nanoseconds(Number frequency) {
        long period = 1000000000L;
        return period /= frequency.longValue();
    }

    public static long microseconds(Number frequency) {
        long period = 1000000L;
        return period /= frequency.longValue();
    }

    public static float milliseconds(Number frequency) {
        float period = 1000.0f;
        return period /= (float)frequency.longValue();
    }

    public static int getFrequencyFromNanos(Number nanoseconds) {
        if (nanoseconds.longValue() <= 0L) {
            return 0;
        }
        long period = 1000000000L;
        int frequency = (int)Math.round((double)period / ((double)nanoseconds.longValue() * 1.0));
        return frequency;
    }
}

