/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.stream.Collectors;

public class ReflectionUtil {
    public static Collection<Class> getAllInterfacesSorted(Object target) {
        return ReflectionUtil.getAllInterfaces(target.getClass()).stream().sorted(Comparator.comparing(Class::getName)).collect(Collectors.toList());
    }

    public static Collection<Class> getAllInterfaces(Object target) {
        return ReflectionUtil.getAllInterfaces(target.getClass());
    }

    public static Collection<Class> getAllInterfaces(Class targetClass) {
        HashSet<Class> results = new HashSet<Class>();
        for (Class<?> ifc : targetClass.getInterfaces()) {
            results.add(ifc);
            results.addAll(ReflectionUtil.getAllInterfaces(ifc));
        }
        if (targetClass.getSuperclass() != null) {
            results.addAll(ReflectionUtil.getAllInterfaces(targetClass.getSuperclass()));
        }
        for (Class<?> ifc : targetClass.getInterfaces()) {
            if (ifc.getSuperclass() == null) continue;
            results.addAll(ReflectionUtil.getAllInterfaces(ifc.getSuperclass()));
        }
        return results;
    }

    public static Collection<Class> getAllClasses(Object target) {
        HashSet results = new HashSet();
        return ReflectionUtil.getAllClasses(target.getClass());
    }

    public static Collection<Class> getAllClasses(Class targetClass) {
        HashSet<Class> results = new HashSet<Class>();
        results.add(targetClass);
        if (targetClass.getSuperclass() != null) {
            results.add(targetClass.getSuperclass());
            results.addAll(ReflectionUtil.getAllClasses(targetClass.getSuperclass()));
        }
        return results;
    }
}

