/*
 * Decompiled with CFR 0.152.
 */
package io.helins.linux;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import io.helins.linux.SizeT;

public class NativeMemory {
    private static native int memcmp(Pointer var0, Pointer var1, SizeT var2);

    private static native void memcpy(Pointer var0, Pointer var1, SizeT var2);

    private static native void memset(Pointer var0, int var1, SizeT var2);

    private NativeMemory() {
    }

    public static void copy(Pointer ptrOrigin, Pointer ptrTarget, SizeT n) {
        NativeMemory.memcpy(ptrOrigin, ptrTarget, n);
    }

    public static void copy(Memory ptrOrigin, Pointer ptrTarget) {
        NativeMemory.memcpy(ptrOrigin, ptrTarget, new SizeT(ptrOrigin.size()));
    }

    public static boolean equal(Pointer ptr1, Pointer ptr2, SizeT n) {
        return NativeMemory.memcmp(ptr1, ptr2, n) == 0;
    }

    public static boolean equal(Memory ptr1, Pointer ptr2) {
        return NativeMemory.equal(ptr1, ptr2, new SizeT(ptr1.size()));
    }

    public static boolean equal(Pointer ptr1, Memory ptr2) {
        return NativeMemory.equal(ptr1, ptr2, new SizeT(ptr2.size()));
    }

    public static boolean equal(Memory ptr1, Memory ptr2) {
        return NativeMemory.equal(ptr1, (Pointer)ptr2);
    }

    public static void fill(Pointer ptr, int b, SizeT n) {
        NativeMemory.memset(ptr, b, n);
    }

    public static void fill(Memory ptr, int b) {
        NativeMemory.fill(ptr, b, new SizeT(ptr.size()));
    }

    public static int getUnsignedByte(Pointer ptr, long offset) {
        return ptr.getByte(offset) & 0xFF;
    }

    public static void setUnsignedByte(Pointer ptr, long offset, int b) {
        ptr.setByte(offset, (byte)b);
    }

    public static int getUnsignedShort(Pointer ptr, long offset) {
        return ptr.getShort(offset) & 0xFFFF;
    }

    public static void setUnsignedShort(Pointer ptr, long offset, int s2) {
        ptr.setShort(offset, (short)s2);
    }

    public static long getUnsignedInt(Pointer ptr, long offset) {
        return (long)ptr.getInt(offset) & 0xFFFFFFFFL;
    }

    public static void setUnsignedInt(Pointer ptr, long offset, long i) {
        ptr.setInt(offset, (int)i);
    }

    static {
        Native.register("c");
    }
}

