/*
 * Decompiled with CFR 0.152.
 */
package io.helins.linux.epoll;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import io.helins.linux.Linux;
import io.helins.linux.epoll.EpollEvent;
import io.helins.linux.epoll.EpollEvents;
import io.helins.linux.io.LinuxIO;
import java.io.IOException;

public class Epoll
implements AutoCloseable {
    private static final int EPOLL_CTL_ADD = 1;
    private static final int EPOLL_CTL_DEL = 2;
    private static final int EPOLL_CTL_MOD = 3;
    private int epfd = Epoll.epoll_create(1);
    private boolean isClosed;

    private static native int epoll_create(int var0);

    private static native int epoll_ctl(int var0, int var1, int var2, Pointer var3);

    private static native int epoll_wait(int var0, Pointer var1, int var2, int var3);

    public Epoll() throws IOException {
        if (this.epfd < 0) {
            int errno = Linux.getErrno();
            switch (errno) {
                case 24: {
                    throw new IOException("Per-user limit on the number of epoll instances or per-process limit on the number of file descriptor has been reached");
                }
                case 23: {
                    throw new IOException("System-wide limit on the number of file descriptors has been reached");
                }
            }
            throw new IOException("Native error while create epoll instance : errno " + errno);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            if (LinuxIO.close(this.epfd) != 0) {
                throw new IOException("Native error while closing epoll instance : errno " + Linux.getErrno());
            }
            this.isClosed = true;
        }
    }

    private void guardClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("Cannot perform operation on a closed epoll instance");
        }
    }

    public int getEpollFD() {
        this.guardClosed();
        return this.epfd;
    }

    private static void operationException(int errno) throws IOException {
        switch (errno) {
            case 9: {
                throw new IllegalArgumentException("Given file descriptor is invalid");
            }
            case 12: {
                throw new IOException("Kernel has unsufficient memory for acting on file descriptor");
            }
        }
    }

    public Epoll add(int fd, EpollEvent event) throws IOException {
        this.guardClosed();
        if (fd == this.epfd) {
            throw new IllegalArgumentException("Given file descriptor cannot be the same as the file descriptor of this epoll instance");
        }
        if (Epoll.epoll_ctl(this.epfd, 1, fd, event.ptr) < 0) {
            int errno = Linux.getErrno();
            Epoll.operationException(errno);
            switch (errno) {
                case 17: {
                    throw new IllegalArgumentException("Given file descriptor has already been added");
                }
                case 28: {
                    throw new IOException("Limit of maximum user epoll watches reached");
                }
                case 1: {
                    throw new UnsupportedOperationException("Given file descriptor does not support epoll");
                }
            }
            throw new IOException("Native error while adding file descriptor : errno " + errno);
        }
        return this;
    }

    public Epoll modify(int fd, EpollEvent event) throws IOException {
        this.guardClosed();
        if (Epoll.epoll_ctl(this.epfd, 3, fd, event.ptr) < 0) {
            int errno = Linux.getErrno();
            Epoll.operationException(errno);
            switch (errno) {
                case 2: {
                    throw new IllegalStateException("Unable to modify file descriptor which has not been added");
                }
            }
            throw new IOException("Native error while modifying file descriptor properties : errno " + errno);
        }
        return this;
    }

    public Epoll remove(int fd) throws IOException {
        this.guardClosed();
        if (Epoll.epoll_ctl(this.epfd, 2, fd, null) < 0) {
            int errno = Linux.getErrno();
            Epoll.operationException(errno);
            switch (errno) {
                case 2: {
                    throw new IllegalStateException("Unable to remove file descriptor which has not been added");
                }
            }
            throw new IOException("Native error while removing file descriptor : errno " + errno);
        }
        return this;
    }

    public void wait(EpollEvent event) throws IOException {
        this.wait(event, -1);
    }

    public boolean wait(EpollEvent event, int timeout) throws IOException {
        return this.wait(event.ptr, 1, timeout) > 0;
    }

    public int wait(EpollEvents events) throws IOException {
        return this.wait(events, -1);
    }

    public int wait(EpollEvents events, int timeout) throws IOException {
        return this.wait(events.memory, events.events.length, timeout);
    }

    private int wait(Pointer events, int maxEvents, int timeout) throws IOException {
        this.guardClosed();
        int result = Epoll.epoll_wait(this.epfd, events, maxEvents, timeout);
        if (result < 0) {
            throw new IOException("Native error while waiting for an epoll event : errno " + Linux.getErrno());
        }
        if (result == 0 && timeout < 0) {
            throw new IOException("Epoll unexpectedly unblocked before an event occured");
        }
        return result;
    }

    static {
        Native.register("c");
    }
}

