/*
 * Decompiled with CFR 0.152.
 */
package io.helins.linux.epoll;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import io.helins.linux.epoll.internal.NativeEpollEvent;

public class EpollEvent {
    Pointer ptr;

    public EpollEvent() {
        Memory memory = new Memory(NativeEpollEvent.SIZE);
        memory.clear();
        this.ptr = memory;
    }

    EpollEvent(Pointer ptr) {
        this.ptr = ptr;
    }

    public Flags getFlags() {
        return new Flags(this.ptr.getInt(NativeEpollEvent.OFFSET_EVENTS));
    }

    public EpollEvent setFlags(Flags flags) {
        this.ptr.setInt(NativeEpollEvent.OFFSET_EVENTS, flags.value);
        return this;
    }

    public long getUserData() {
        return this.ptr.getLong(NativeEpollEvent.OFFSET_USER_DATA);
    }

    public EpollEvent setUserData(long value) {
        this.ptr.setLong(NativeEpollEvent.OFFSET_USER_DATA, value);
        return this;
    }

    public static class Flags {
        int value;

        public Flags() {
            this.value = 0;
        }

        Flags(int value) {
            this.value = value;
        }

        public boolean isSet(Flag flag) {
            return (this.value & flag.value) > 0;
        }

        public Flags set(Flag flag) {
            this.value |= flag.value;
            return this;
        }

        public Flags unset(Flag flag) {
            this.value &= ~flag.value;
            return this;
        }

        public Flags clear() {
            this.value = 0;
            return this;
        }
    }

    public static enum Flag {
        EPOLLIN(1),
        EPOLLPRI(2),
        EPOLLOUT(4),
        EPOLLRDBAND(128),
        EPOLLWRBAND(512),
        EPOLLERR(8),
        EPOLLHUP(16),
        EPOLLRDHUP(8192),
        EPOLLWAKEUP(0x20000000),
        EPOLLONESHOT(0x40000000),
        EPOLLT(Integer.MIN_VALUE);

        final int value;

        private Flag(int flag) {
            this.value = flag;
        }
    }
}

