/*
 * Decompiled with CFR 0.152.
 */
package io.helins.linux.epoll;

import com.sun.jna.Memory;
import io.helins.linux.epoll.EpollEvent;
import io.helins.linux.epoll.internal.NativeEpollEvent;

public class EpollEvents {
    EpollEvent[] events;
    Memory memory;

    public EpollEvents(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("The number of epoll events must be >= 1");
        }
        this.memory = new Memory(size * NativeEpollEvent.SIZE);
        this.events = new EpollEvent[size];
        this.memory.clear();
        for (int i = 0; i < size; ++i) {
            this.events[i] = new EpollEvent(this.memory.share(i * NativeEpollEvent.SIZE));
        }
    }

    public EpollEvent getEpollEvent(int index) {
        return this.events[index];
    }
}

