/*
 * Decompiled with CFR 0.152.
 */
package io.helins.linux.gpio;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import io.helins.linux.gpio.GpioLine;

public class GpioBuffer {
    public static final int SIZE = 64;
    private final Memory buffer = new Memory(64L);

    public GpioBuffer() {
        this.buffer.clear();
    }

    public boolean get(GpioLine line) {
        return this.buffer.getByte(line.index) == 1;
    }

    public GpioBuffer set(GpioLine line, boolean value) {
        this.buffer.setByte(line.index, (byte)(value ? 1 : 0));
        return this;
    }

    public GpioBuffer toggle(GpioLine line) {
        this.set(line, !this.get(line));
        return this;
    }

    public GpioBuffer clear() {
        this.buffer.clear();
        return this;
    }

    Pointer getPointer() {
        return this.buffer;
    }
}

