/*
 * Decompiled with CFR 0.152.
 */
package io.helins.linux.gpio;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import io.helins.linux.Linux;
import io.helins.linux.gpio.GpioChipInfo;
import io.helins.linux.gpio.GpioEventHandle;
import io.helins.linux.gpio.GpioEventRequest;
import io.helins.linux.gpio.GpioHandle;
import io.helins.linux.gpio.GpioHandleRequest;
import io.helins.linux.gpio.GpioLineInfo;
import io.helins.linux.io.LinuxIO;
import java.io.FileNotFoundException;
import java.io.IOException;

public class GpioDevice
implements AutoCloseable {
    private static final NativeLong GPIO_GET_CHIPINFO_IOCTL = new NativeLong(2151986177L, true);
    private static final NativeLong GPIO_GET_LINEINFO_IOCTL = new NativeLong(3225990146L, true);
    private static final NativeLong GPIO_GET_LINEHANDLE_IOCTL = new NativeLong(3245126659L, true);
    private static final NativeLong GPIO_GET_LINEEVENT_IOCTL = new NativeLong(3224417284L, true);
    private int fd;
    private boolean isClosed = false;

    public GpioDevice(String path) throws IOException {
        int fd = LinuxIO.open64(path, 0);
        if (fd < 0) {
            int errno = Linux.getErrno();
            switch (errno) {
                case 13: {
                    throw new FileNotFoundException("Permission denied : " + path);
                }
                case 2: {
                    throw new FileNotFoundException("No such file : " + path);
                }
            }
            throw new IOException("Native error while opening GPIO device at '" + path + "' : errno " + errno);
        }
        this.fd = fd;
    }

    public GpioDevice(int number) throws IOException {
        this("/dev/gpiochip" + number);
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            if (LinuxIO.close(this.fd) != 0) {
                throw new IOException("Native error while closing GPIO device : errno " + Linux.getErrno());
            }
            this.isClosed = true;
        }
    }

    private void guardClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("Unable to perform IO operation on a closed GPIO device");
        }
    }

    private static void throwIfBadDevice(int errno) throws IOException {
        if (errno == 25) {
            throw new IOException("Device does not support this GPIO operation");
        }
    }

    public GpioChipInfo requestChipInfo() throws IOException {
        return this.requestChipInfo(new GpioChipInfo());
    }

    public GpioChipInfo requestChipInfo(GpioChipInfo info) throws IOException {
        this.guardClosed();
        if (LinuxIO.ioctl(this.fd, GPIO_GET_CHIPINFO_IOCTL, info.memory) < 0) {
            int errno = Linux.getErrno();
            GpioDevice.throwIfBadDevice(errno);
            throw new IOException("Native error while requesting chip information : errno " + errno);
        }
        return info;
    }

    public GpioLineInfo requestLineInfo(int line) throws IOException {
        return this.requestLineInfo(line, new GpioLineInfo());
    }

    public GpioLineInfo requestLineInfo(int line, GpioLineInfo info) throws IOException {
        this.guardClosed();
        info.setLine(line);
        Pointer ptr = new Pointer(Pointer.nativeValue(info.memory));
        if (LinuxIO.ioctl(this.fd, GPIO_GET_LINEINFO_IOCTL, info.memory) < 0) {
            int errno = Linux.getErrno();
            GpioDevice.throwIfBadDevice(errno);
            throw new IOException("Native error while requesting information about a GPIO line : errno " + errno);
        }
        return info;
    }

    private static void throwIfHandleError(int errno) throws IOException {
        GpioDevice.throwIfBadDevice(errno);
        switch (errno) {
            case 16: {
                throw new IOException("A requested line is already being used elsewhere");
            }
            case 22: {
                throw new IllegalArgumentException("Part of the request for a GPIO handle or event handle is invalid");
            }
        }
    }

    public GpioHandle requestHandle(GpioHandleRequest request) throws IOException {
        this.guardClosed();
        if (LinuxIO.ioctl(this.fd, GPIO_GET_LINEHANDLE_IOCTL, request.memory) < 0) {
            int errno = Linux.getErrno();
            GpioDevice.throwIfHandleError(errno);
            throw new IOException("Native error while requesting a GPIO handle : errno " + errno);
        }
        return new GpioHandle(request.getFD());
    }

    public GpioEventHandle requestEvent(GpioEventRequest request) throws IOException {
        this.guardClosed();
        if (LinuxIO.ioctl(this.fd, GPIO_GET_LINEEVENT_IOCTL, request.memory) < 0) {
            int errno = Linux.getErrno();
            GpioDevice.throwIfHandleError(errno);
            throw new IOException("Native error while requesting a GPIO event handle : errno " + errno);
        }
        return new GpioEventHandle(request.getFD(), request.getLine());
    }
}

