/*
 * Decompiled with CFR 0.152.
 */
package io.helins.linux.gpio;

import io.helins.linux.Linux;
import io.helins.linux.gpio.internal.NativeGpioEventData;
import io.helins.linux.io.LinuxIO;
import java.io.IOException;

public class GpioEvent {
    private static final int GPIO_EVENT_RISING_EDGE = 1;
    private static final int GPIO_EVENT_FALLING_EDGE = 2;
    final NativeGpioEventData nativeStruct = new NativeGpioEventData();
    int id = 0;

    void read(int fd) throws IOException {
        this.read(fd, 0);
    }

    void read(int fd, int id) throws IOException {
        if (LinuxIO.read(fd, this.nativeStruct.getPointer(), NativeGpioEventData.SIZE).intValue() < 0) {
            throw new IOException("Native error while reading a GPIO event : errno " + Linux.getErrno());
        }
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public long getNanoTimestamp() {
        return this.nativeStruct.readTimestamp();
    }

    public boolean isRising() {
        return (this.nativeStruct.readId() & 1) > 0;
    }

    public boolean isFalling() {
        return (this.nativeStruct.readId() & 2) > 0;
    }
}

