/*
 * Decompiled with CFR 0.152.
 */
package io.helins.linux.gpio;

import io.helins.linux.Linux;
import io.helins.linux.gpio.GpioBuffer;
import io.helins.linux.gpio.GpioEvent;
import io.helins.linux.gpio.GpioHandle;
import io.helins.linux.gpio.GpioLine;
import io.helins.linux.io.LinuxIO;
import java.io.IOException;

public class GpioEventHandle
implements AutoCloseable {
    final int fd;
    private final GpioLine line;
    private boolean isClosed = false;

    GpioEventHandle(int fd, int line) {
        this.fd = fd;
        this.line = new GpioLine(line, 0);
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            if (LinuxIO.close(this.fd) != 0) {
                throw new IOException("Native error while closing a GPIO event handle for line " + this.line.lineNumber + " : errno " + Linux.getErrno());
            }
            this.isClosed = true;
        }
    }

    public GpioLine getLine() {
        return this.line;
    }

    public void read(GpioBuffer buffer) throws IOException {
        if (LinuxIO.ioctl(this.fd, GpioHandle.GPIOHANDLE_GET_LINE_VALUES_IOCTL, buffer.getPointer()) < 0) {
            throw new IOException("Native error while reading GPIO event handle for line " + this.line.lineNumber + " : errno " + Linux.getErrno());
        }
    }

    public GpioEvent waitForEvent() throws IOException {
        return this.waitForEvent(new GpioEvent());
    }

    public GpioEvent waitForEvent(GpioEvent data) throws IOException {
        data.read(this.fd, this.line.lineNumber);
        return data;
    }
}

