/*
 * Decompiled with CFR 0.152.
 */
package io.helins.linux.gpio;

import io.helins.linux.epoll.Epoll;
import io.helins.linux.epoll.EpollEvent;
import io.helins.linux.gpio.GpioEvent;
import io.helins.linux.gpio.GpioEventHandle;
import java.io.IOException;

public class GpioEventWatcher
implements AutoCloseable {
    private static final EpollEvent.Flags eventFlags = new EpollEvent.Flags().set(EpollEvent.Flag.EPOLLIN).set(EpollEvent.Flag.EPOLLPRI);
    private Epoll epoll = new Epoll();
    private EpollEvent epollEvent = new EpollEvent();

    @Override
    public void close() throws IOException {
        this.epoll.close();
    }

    private static long encodeUserData(int fd, int id) {
        return (long)fd | ((long)id & 0xFFFFFFFFL) << 32;
    }

    private static int decodeFD(long userData) {
        return (int)userData;
    }

    private static int decodeID(long userData) {
        return (int)(userData >>> 32);
    }

    public GpioEventWatcher addHandle(GpioEventHandle handle, int id) throws IOException {
        EpollEvent epollEvent = new EpollEvent();
        epollEvent.setFlags(eventFlags).setUserData(GpioEventWatcher.encodeUserData(handle.fd, id));
        this.epoll.add(handle.fd, epollEvent);
        return this;
    }

    public GpioEventWatcher removeHandle(GpioEventHandle handle) throws IOException {
        this.epoll.remove(handle.fd);
        return this;
    }

    public void waitForEvent(GpioEvent data) throws IOException {
        this.waitForEvent(data, -1);
    }

    public boolean waitForEvent(GpioEvent data, int timeout) throws IOException {
        if (this.epoll.wait(this.epollEvent, timeout)) {
            long userData = this.epollEvent.getUserData();
            int id = GpioEventWatcher.decodeID(userData);
            if (this.epollEvent.getFlags().isSet(EpollEvent.Flag.EPOLLERR)) {
                throw new IOException("Error condition detected for monitored input with id " + id);
            }
            data.read(GpioEventWatcher.decodeFD(userData), id);
            return true;
        }
        return false;
    }
}

