/*
 * Decompiled with CFR 0.152.
 */
package io.helins.linux.gpio;

import com.sun.jna.NativeLong;
import io.helins.linux.Linux;
import io.helins.linux.gpio.GpioBuffer;
import io.helins.linux.io.LinuxIO;
import java.io.IOException;

public class GpioHandle
implements AutoCloseable {
    static final NativeLong GPIOHANDLE_GET_LINE_VALUES_IOCTL = new NativeLong(3225465864L, true);
    static final NativeLong GPIOHANDLE_SET_LINE_VALUES_IOCTL = new NativeLong(3225465865L, true);
    final int fd;
    private boolean isClosed = false;

    GpioHandle(int fd) {
        this.fd = fd;
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            if (LinuxIO.close(this.fd) != 0) {
                throw new IOException("Native error while closing GPIO handle : errno " + Linux.getErrno());
            }
            this.isClosed = true;
        }
    }

    private void guardClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("Unable to perform IO operation on closed GPIO handle");
        }
    }

    public void read(GpioBuffer buffer) throws IOException {
        this.guardClosed();
        if (LinuxIO.ioctl(this.fd, GPIOHANDLE_GET_LINE_VALUES_IOCTL, buffer.getPointer()) < 0) {
            throw new IOException("Native error while reading a GPIO handle : errno " + Linux.getErrno());
        }
    }

    public void write(GpioBuffer buffer) throws IOException {
        this.guardClosed();
        if (LinuxIO.ioctl(this.fd, GPIOHANDLE_SET_LINE_VALUES_IOCTL, buffer.getPointer()) < 0) {
            throw new IOException("Native error while writing to a GPIO handle : errno " + Linux.getErrno());
        }
    }
}

