/*
 * Decompiled with CFR 0.152.
 */
package io.helins.linux.gpio;

import com.sun.jna.Memory;
import io.helins.linux.gpio.GpioFlags;
import io.helins.linux.gpio.GpioLine;
import io.helins.linux.gpio.GpioUtils;
import io.helins.linux.gpio.internal.NativeGpioHandleRequest;

public class GpioHandleRequest {
    final Memory memory = new Memory(NativeGpioHandleRequest.SIZE);

    public GpioHandleRequest() {
        this.memory.clear();
    }

    private GpioHandleRequest setRawFlags(int flags) {
        this.memory.setInt(NativeGpioHandleRequest.OFFSET_FLAGS, flags);
        return this;
    }

    public GpioHandleRequest setFlags(GpioFlags flags) {
        return this.setRawFlags(flags.forRequest());
    }

    public GpioHandleRequest unsetFlags() {
        return this.setRawFlags(0);
    }

    public GpioFlags getFlags() {
        return new GpioFlags().fromRequest(this.memory.getInt(NativeGpioHandleRequest.OFFSET_FLAGS));
    }

    public String getConsumer() {
        return GpioUtils.getString(this.memory, NativeGpioHandleRequest.OFFSET_CONSUMER);
    }

    public GpioHandleRequest setConsumer(String consumer) {
        GpioUtils.setConsumer(this.memory, NativeGpioHandleRequest.OFFSET_CONSUMER, consumer);
        return this;
    }

    int getFD() {
        return this.memory.getInt(NativeGpioHandleRequest.OFFSET_FD);
    }

    public GpioLine addLine(int lineNumber) {
        int index = this.memory.getInt(NativeGpioHandleRequest.OFFSET_LINES);
        this.memory.setInt(NativeGpioHandleRequest.OFFSET_LINE_OFFSETS + 4 * index, lineNumber);
        this.memory.setInt(NativeGpioHandleRequest.OFFSET_LINES, index + 1);
        return new GpioLine(lineNumber, index);
    }

    public GpioLine addLine(int lineNumber, boolean value) {
        GpioLine gpioLine = this.addLine(lineNumber);
        this.memory.setByte(NativeGpioHandleRequest.OFFSET_DEFAULT_VALUES + gpioLine.index, (byte)(value ? 1 : 0));
        return gpioLine;
    }
}

