/*
 * Decompiled with CFR 0.152.
 */
package io.helins.linux.gpio;

import com.sun.jna.Memory;
import io.helins.linux.gpio.GpioFlags;
import io.helins.linux.gpio.GpioUtils;
import io.helins.linux.gpio.internal.NativeGpioLineInfo;

public class GpioLineInfo {
    final Memory memory = new Memory(NativeGpioLineInfo.SIZE);

    public GpioLineInfo() {
        this.memory.clear();
    }

    public String getConsumer() {
        return GpioUtils.getString(this.memory, NativeGpioLineInfo.OFFSET_CONSUMER);
    }

    public int getLine() {
        return this.memory.getInt(NativeGpioLineInfo.OFFSET_LINE);
    }

    void setLine(int line) {
        this.memory.setInt(NativeGpioLineInfo.OFFSET_LINE, line);
    }

    public String getName() {
        return GpioUtils.getString(this.memory, NativeGpioLineInfo.OFFSET_NAME);
    }

    private int getRawFlags() {
        return this.memory.getInt(NativeGpioLineInfo.OFFSET_FLAGS);
    }

    public GpioFlags getFlags() {
        return new GpioFlags().fromLineInfo(this.getRawFlags());
    }

    public boolean isUsed() {
        return GpioUtils.isSet(this.getRawFlags(), 1);
    }
}

