/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.core;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.Babel;
import pt.unl.fct.di.novasys.babel.core.BabelSecurity;
import pt.unl.fct.di.novasys.babel.core.security.IdentityCrypt;
import pt.unl.fct.di.novasys.babel.core.security.IdentityPair;
import pt.unl.fct.di.novasys.babel.core.security.SecretCrypt;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.exceptions.NoSuchProtocolException;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.babel.generic.ProtoNotification;
import pt.unl.fct.di.novasys.babel.generic.ProtoReply;
import pt.unl.fct.di.novasys.babel.generic.ProtoRequest;
import pt.unl.fct.di.novasys.babel.generic.ProtoTimer;
import pt.unl.fct.di.novasys.babel.handlers.ChannelEventHandler;
import pt.unl.fct.di.novasys.babel.handlers.MessageFailedHandler;
import pt.unl.fct.di.novasys.babel.handlers.MessageInHandler;
import pt.unl.fct.di.novasys.babel.handlers.MessageSentHandler;
import pt.unl.fct.di.novasys.babel.handlers.NotificationHandler;
import pt.unl.fct.di.novasys.babel.handlers.ReplyHandler;
import pt.unl.fct.di.novasys.babel.handlers.RequestHandler;
import pt.unl.fct.di.novasys.babel.handlers.SecureMessageFailedHandler;
import pt.unl.fct.di.novasys.babel.handlers.SecureMessageInHandler;
import pt.unl.fct.di.novasys.babel.handlers.SecureMessageSentHandler;
import pt.unl.fct.di.novasys.babel.handlers.TimerHandler;
import pt.unl.fct.di.novasys.babel.internal.BabelMessage;
import pt.unl.fct.di.novasys.babel.internal.CustomChannelEvent;
import pt.unl.fct.di.novasys.babel.internal.IPCEvent;
import pt.unl.fct.di.novasys.babel.internal.InternalEvent;
import pt.unl.fct.di.novasys.babel.internal.MessageFailedEvent;
import pt.unl.fct.di.novasys.babel.internal.MessageInEvent;
import pt.unl.fct.di.novasys.babel.internal.MessageSentEvent;
import pt.unl.fct.di.novasys.babel.internal.NotificationEvent;
import pt.unl.fct.di.novasys.babel.internal.TimerEvent;
import pt.unl.fct.di.novasys.babel.internal.security.PeerIdEncoder;
import pt.unl.fct.di.novasys.babel.metrics.Counter;
import pt.unl.fct.di.novasys.babel.metrics.Metric;
import pt.unl.fct.di.novasys.babel.metrics.MetricsManager;
import pt.unl.fct.di.novasys.channel.ChannelEvent;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;

public abstract class GenericProtocol {
    private static final Logger logger = LogManager.getLogger(GenericProtocol.class);
    private final BlockingQueue<InternalEvent> queue;
    private final Thread executionThread;
    private final String protoName;
    private final short protoId;
    private boolean protocolThreadedStarted;
    private int defaultChannel;
    private IdentityCrypt defaultIdentityCrypt;
    private IdentityPair defaultIdentity;
    private SecretCrypt defaultSecret;
    private final Map<Integer, ChannelHandlers> channels;
    private final Map<Short, TimerHandler<? extends ProtoTimer>> timerHandlers;
    private final Map<Short, RequestHandler<? extends ProtoRequest>> requestHandlers;
    private final Map<Short, ReplyHandler<? extends ProtoReply>> replyHandlers;
    private final Map<Short, NotificationHandler<? extends ProtoNotification>> notificationHandlers;
    public static final Babel babel = Babel.getInstance();
    public static final BabelSecurity babelSecurity = BabelSecurity.getInstance();
    private final ProtocolMetricsBabelMetrics metrics_babel;

    public GenericProtocol(String protoName, short protoId, BlockingQueue<InternalEvent> policy) {
        this.queue = policy;
        this.protoId = protoId;
        this.protoName = protoName;
        this.protocolThreadedStarted = false;
        this.executionThread = new Thread(this::mainLoop, protoId + "-" + protoName);
        this.channels = new HashMap<Integer, ChannelHandlers>();
        this.defaultChannel = -1;
        this.timerHandlers = new HashMap<Short, TimerHandler<? extends ProtoTimer>>();
        this.requestHandlers = new HashMap<Short, RequestHandler<? extends ProtoRequest>>();
        this.replyHandlers = new HashMap<Short, ReplyHandler<? extends ProtoReply>>();
        this.notificationHandlers = new HashMap<Short, NotificationHandler<? extends ProtoNotification>>();
        this.metrics_babel = new ProtocolMetricsBabelMetrics(protoId, protoName);
    }

    public final boolean hasProtocolThreadStarted() {
        return this.protocolThreadedStarted;
    }

    public GenericProtocol(String protoName, short protoId) {
        this(protoName, protoId, new LinkedBlockingQueue<InternalEvent>());
    }

    public final short getProtoId() {
        return this.protoId;
    }

    public final String getProtoName() {
        return this.protoName;
    }

    public final void startEventThread() {
        if (this.protocolThreadedStarted) {
            return;
        }
        try {
            this.executionThread.start();
            this.protocolThreadedStarted = true;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    public abstract void init(Properties var1) throws HandlerRegistrationException, IOException;

    protected long getMillisSinceBabelStart() {
        return babel.getMillisSinceStart();
    }

    private <V> void registerHandler(short id, V handler, Map<Short, V> handlerMap) throws HandlerRegistrationException {
        if (handlerMap.putIfAbsent(id, handler) != null) {
            throw new HandlerRegistrationException("Conflict in registering handler for " + handler.getClass().toString() + " with id " + id + ".");
        }
    }

    protected final <V extends ProtoMessage> void registerMessageHandler(int cId, short msgId, MessageInHandler<V> inHandler) throws HandlerRegistrationException {
        this.registerMessageHandler(cId, msgId, inHandler, (SecureMessageSentHandler<V>)null, (SecureMessageFailedHandler<V>)null);
    }

    protected final <V extends ProtoMessage> void registerMessageHandler(int cId, short msgId, SecureMessageInHandler<V> inHandler) throws HandlerRegistrationException {
        this.registerMessageHandler(cId, msgId, inHandler, (SecureMessageSentHandler<V>)null, (SecureMessageFailedHandler<V>)null);
    }

    protected final <V extends ProtoMessage> void registerMessageHandler(int cId, short msgId, MessageInHandler<V> inHandler, MessageSentHandler<V> sentHandler) throws HandlerRegistrationException {
        this.registerMessageHandler(cId, msgId, inHandler, sentHandler, (SecureMessageFailedHandler<V>)null);
    }

    protected final <V extends ProtoMessage> void registerMessageHandler(int cId, short msgId, SecureMessageInHandler<V> inHandler, MessageSentHandler<V> sentHandler) throws HandlerRegistrationException {
        this.registerMessageHandler(cId, msgId, inHandler, sentHandler, (SecureMessageFailedHandler<V>)null);
    }

    protected final <V extends ProtoMessage> void registerMessageHandler(int cId, short msgId, MessageInHandler<V> inHandler, SecureMessageSentHandler<V> sentHandler) throws HandlerRegistrationException {
        this.registerMessageHandler(cId, msgId, inHandler, sentHandler, (SecureMessageFailedHandler<V>)null);
    }

    protected final <V extends ProtoMessage> void registerMessageHandler(int cId, short msgId, SecureMessageInHandler<V> inHandler, SecureMessageSentHandler<V> sentHandler) throws HandlerRegistrationException {
        this.registerMessageHandler(cId, msgId, inHandler, sentHandler, (SecureMessageFailedHandler<V>)null);
    }

    protected final <V extends ProtoMessage> void registerMessageHandler(int cId, short msgId, MessageInHandler<V> inHandler, MessageFailedHandler<V> failHandler) throws HandlerRegistrationException {
        this.registerMessageHandler(cId, msgId, inHandler, (SecureMessageSentHandler<V>)null, failHandler);
    }

    protected final <V extends ProtoMessage> void registerMessageHandler(int cId, short msgId, SecureMessageInHandler<V> inHandler, MessageFailedHandler<V> failHandler) throws HandlerRegistrationException {
        this.registerMessageHandler(cId, msgId, inHandler, (SecureMessageSentHandler<V>)null, failHandler);
    }

    protected final <V extends ProtoMessage> void registerMessageHandler(int cId, short msgId, MessageInHandler<V> inHandler, SecureMessageFailedHandler<V> failHandler) throws HandlerRegistrationException {
        this.registerMessageHandler(cId, msgId, inHandler, (SecureMessageSentHandler<V>)null, failHandler);
    }

    protected final <V extends ProtoMessage> void registerMessageHandler(int cId, short msgId, SecureMessageInHandler<V> inHandler, SecureMessageFailedHandler<V> failHandler) throws HandlerRegistrationException {
        this.registerMessageHandler(cId, msgId, inHandler, (SecureMessageSentHandler<V>)null, failHandler);
    }

    protected final <V extends ProtoMessage> void registerMessageHandler(int cId, short msgId, MessageInHandler<V> inHandler, MessageSentHandler<V> sentHandler, MessageFailedHandler<V> failHandler) throws HandlerRegistrationException {
        this.registerHandler(msgId, inHandler, this.getChannelOrThrow((int)cId).messageInHandlers);
        if (sentHandler != null) {
            this.registerHandler(msgId, sentHandler, this.getChannelOrThrow((int)cId).messageSentHandlers);
        }
        if (failHandler != null) {
            this.registerHandler(msgId, failHandler, this.getChannelOrThrow((int)cId).messageFailedHandlers);
        }
    }

    protected final <V extends ProtoMessage> void registerMessageHandler(int cId, short msgId, SecureMessageInHandler<V> inHandler, MessageSentHandler<V> sentHandler, MessageFailedHandler<V> failHandler) throws HandlerRegistrationException {
        this.registerMessageHandler(cId, msgId, (MessageInHandler<V>)inHandler, sentHandler, failHandler);
    }

    protected final <V extends ProtoMessage> void registerMessageHandler(int cId, short msgId, MessageInHandler<V> inHandler, SecureMessageSentHandler<V> sentHandler, MessageFailedHandler<V> failHandler) throws HandlerRegistrationException {
        this.registerMessageHandler(cId, msgId, inHandler, (MessageSentHandler<V>)sentHandler, failHandler);
    }

    protected final <V extends ProtoMessage> void registerMessageHandler(int cId, short msgId, SecureMessageInHandler<V> inHandler, SecureMessageSentHandler<V> sentHandler, MessageFailedHandler<V> failHandler) throws HandlerRegistrationException {
        this.registerMessageHandler(cId, msgId, (MessageInHandler<V>)inHandler, (MessageSentHandler<V>)sentHandler, failHandler);
    }

    protected final <V extends ProtoMessage> void registerMessageHandler(int cId, short msgId, MessageInHandler<V> inHandler, MessageSentHandler<V> sentHandler, SecureMessageFailedHandler<V> failHandler) throws HandlerRegistrationException {
        this.registerMessageHandler(cId, msgId, inHandler, sentHandler, (MessageFailedHandler<V>)failHandler);
    }

    protected final <V extends ProtoMessage> void registerMessageHandler(int cId, short msgId, SecureMessageInHandler<V> inHandler, MessageSentHandler<V> sentHandler, SecureMessageFailedHandler<V> failHandler) throws HandlerRegistrationException {
        this.registerMessageHandler(cId, msgId, (MessageInHandler<V>)inHandler, sentHandler, (MessageFailedHandler<V>)failHandler);
    }

    protected final <V extends ProtoMessage> void registerMessageHandler(int cId, short msgId, MessageInHandler<V> inHandler, SecureMessageSentHandler<V> sentHandler, SecureMessageFailedHandler<V> failHandler) throws HandlerRegistrationException {
        this.registerMessageHandler(cId, msgId, inHandler, (MessageSentHandler<V>)sentHandler, (MessageFailedHandler<V>)failHandler);
    }

    protected final <V extends ProtoMessage> void registerMessageHandler(int cId, short msgId, SecureMessageInHandler<V> inHandler, SecureMessageSentHandler<V> sentHandler, SecureMessageFailedHandler<V> failHandler) throws HandlerRegistrationException {
        this.registerMessageHandler(cId, msgId, (MessageInHandler<V>)inHandler, (MessageSentHandler<V>)sentHandler, (MessageFailedHandler<V>)failHandler);
    }

    protected final <V extends ChannelEvent> void registerChannelEventHandler(int cId, short eventId, ChannelEventHandler<V> handler) throws HandlerRegistrationException {
        this.registerHandler(eventId, handler, this.getChannelOrThrow((int)cId).channelEventHandlers);
    }

    protected final <V extends ProtoTimer> void registerTimerHandler(short timerID, TimerHandler<V> handler) throws HandlerRegistrationException {
        this.registerHandler(timerID, handler, this.timerHandlers);
    }

    protected final <V extends ProtoRequest> void registerRequestHandler(short requestId, RequestHandler<V> handler) throws HandlerRegistrationException {
        this.registerHandler(requestId, handler, this.requestHandlers);
    }

    protected final <V extends ProtoReply> void registerReplyHandler(short replyId, ReplyHandler<V> handler) throws HandlerRegistrationException {
        this.registerHandler(replyId, handler, this.replyHandlers);
    }

    protected final ChannelHandlers getChannelOrThrow(int channelId) {
        ChannelHandlers handlers = this.channels.get(channelId);
        if (handlers == null) {
            throw new AssertionError((Object)("Channel does not exist: " + channelId));
        }
        return handlers;
    }

    protected final void registerMessageSerializer(int channelId, short msgId, ISerializer<? extends ProtoMessage> serializer) {
        babel.registerSerializer(channelId, msgId, serializer);
    }

    protected final int createChannel(String channelName, Properties props) throws IOException {
        int channelId = babel.createChannel(channelName, this.protoId, props);
        this.registerSharedChannel(channelId);
        return channelId;
    }

    protected final int createSecureChannel(String channelName, Properties props) throws IOException {
        int channelId = babel.createSecureChannel(channelName, this.protoId, props, null, null);
        this.registerSharedChannel(channelId);
        return channelId;
    }

    protected final int createSecureChannel(String channelName, Properties props, byte[] identity) throws IOException {
        return this.createSecureChannelWithIdentities(channelName, props, Arrays.asList(new byte[][]{identity}));
    }

    protected final int createSecureChannel(String channelName, Properties props, String identityAlias) throws IOException {
        return this.createSecureChannelWithAliases(channelName, props, Arrays.asList(identityAlias));
    }

    protected final int createSecureChannelWithIdentities(String channelName, Properties props, byte[] ... identities) throws IOException {
        return this.createSecureChannelWithIdentities(channelName, props, Arrays.asList(identities));
    }

    protected final int createSecureChannelWithIdentities(String channelName, Properties props, Collection<byte[]> identities) throws IOException {
        int channelId = babel.createSecureChannel(channelName, this.protoId, props, null, identities);
        this.registerSharedChannel(channelId);
        return channelId;
    }

    protected final int createSecureChannelWithProtoIdentities(String channelName, Properties props) throws IOException {
        return this.createSecureChannelWithAliases(channelName, props, babelSecurity.getAllIdentitiesWithPrefix(this.protoName).stream().map(id -> id.alias()).collect(Collectors.toList()));
    }

    protected final int createSecureChannelWithAliases(String channelName, Properties props, String ... identityAliases) throws IOException {
        return this.createSecureChannelWithAliases(channelName, props, Arrays.asList(identityAliases));
    }

    protected final int createSecureChannelWithAliases(String channelName, Properties props, Collection<String> identityAliases) throws IOException {
        int channelId = babel.createSecureChannel(channelName, this.protoId, props, identityAliases, null);
        this.registerSharedChannel(channelId);
        return channelId;
    }

    protected final void registerSharedChannel(int channelId) {
        babel.registerChannelInterest(channelId, this.protoId, this);
        this.channels.put(channelId, new ChannelHandlers());
        if (this.defaultChannel == -1) {
            this.setDefaultChannel(channelId);
        }
    }

    protected final void setDefaultChannel(int channelId) {
        this.getChannelOrThrow(channelId);
        this.defaultChannel = channelId;
    }

    protected final int getDefaultChannel() {
        return this.defaultChannel;
    }

    protected final void sendMessage(ProtoMessage msg, Host destination) {
        this.sendMessage(this.defaultChannel, msg, this.protoId, destination, 0);
    }

    protected final void sendMessage(int channelId, ProtoMessage msg, Host destination) {
        this.sendMessage(channelId, msg, this.protoId, destination, 0);
    }

    protected final void sendMessage(ProtoMessage msg, short destProto, Host destination) {
        this.sendMessage(this.defaultChannel, msg, destProto, destination, 0);
    }

    protected final void sendMessage(ProtoMessage msg, Host destination, int connection) {
        this.sendMessage(this.defaultChannel, msg, this.protoId, destination, connection);
    }

    protected final void sendMessage(int channelId, ProtoMessage msg, Host destination, int connection) {
        this.sendMessage(channelId, msg, this.protoId, destination, connection);
    }

    protected final void sendMessage(ProtoMessage msg, short destProto, Host destination, int connection) {
        this.sendMessage(this.defaultChannel, msg, destProto, destination, connection);
    }

    protected final void sendMessage(int channelId, ProtoMessage msg, short destProto, Host destination, int connection) {
        this.getChannelOrThrow(channelId);
        if (logger.isDebugEnabled()) {
            logger.debug("Sending: " + String.valueOf(msg) + " to " + String.valueOf(destination) + " proto " + destProto + " channel " + channelId);
        }
        babel.sendMessage(channelId, connection, new BabelMessage(msg, this.protoId, destProto), destination);
    }

    protected final void sendMessage(ProtoMessage msg, byte[] destinationId) {
        this.sendMessage(this.defaultChannel, msg, this.protoId, destinationId, 0);
    }

    protected final void sendMessage(int channelId, ProtoMessage msg, byte[] destinationId) {
        this.sendMessage(channelId, msg, this.protoId, destinationId, 0);
    }

    protected final void sendMessage(ProtoMessage msg, short destProto, byte[] destinationId) {
        this.sendMessage(this.defaultChannel, msg, destProto, destinationId, 0);
    }

    protected final void sendMessage(ProtoMessage msg, byte[] destinationId, int connection) {
        this.sendMessage(this.defaultChannel, msg, this.protoId, destinationId, connection);
    }

    protected final void sendMessage(int channelId, ProtoMessage msg, byte[] destinationId, int connection) {
        this.sendMessage(channelId, msg, this.protoId, destinationId, connection);
    }

    protected final void sendMessage(ProtoMessage msg, short destProto, byte[] destinationId, int connection) {
        this.sendMessage(this.defaultChannel, msg, destProto, destinationId, connection);
    }

    protected final void sendMessage(int channelId, ProtoMessage msg, short destProto, byte[] destinationId, int connection) {
        this.getChannelOrThrow(channelId);
        if (logger.isDebugEnabled()) {
            logger.debug("Sending: " + String.valueOf(msg) + " to " + PeerIdEncoder.encodeToString(destinationId) + " proto " + destProto + " channel " + channelId);
        }
        babel.sendMessage(channelId, connection, new BabelMessage(msg, this.protoId, destProto), destinationId);
    }

    protected final void openConnection(Host peer) {
        this.openConnection(peer, this.defaultChannel);
    }

    protected final void openConnection(Host peer, int channelId) {
        babel.openConnection(channelId, peer, this.protoId);
    }

    protected final void openConnection(Host peer, byte[] peerId) {
        this.openConnection(peer, peerId, this.defaultChannel);
    }

    protected final void openConnection(Host peer, byte[] peerId, int channelId) {
        babel.openConnection(channelId, peer, peerId, this.protoId);
    }

    protected final void closeConnection(Host peer) {
        this.closeConnection(peer, this.defaultChannel);
    }

    protected final void closeConnection(Host peer, int channelId) {
        this.closeConnection(peer, channelId, (int)this.protoId);
    }

    protected final void closeConnection(Host peer, int channelId, int connection) {
        babel.closeConnection(channelId, peer, connection);
    }

    protected final void closeConnection(byte[] peerId) {
        this.closeConnection(peerId, this.defaultChannel);
    }

    protected final void closeConnection(byte[] peerId, int channelId) {
        this.closeConnection(peerId, channelId, (int)this.protoId);
    }

    protected final void closeConnection(byte[] peerId, int channelId, int connection) {
        babel.closeConnection(channelId, peerId, connection);
    }

    protected final void sendRequest(ProtoRequest request, short destination) throws NoSuchProtocolException {
        babel.sendIPC(new IPCEvent(request, this.protoId, destination));
    }

    protected final void sendReply(ProtoReply reply, short destination) throws NoSuchProtocolException {
        babel.sendIPC(new IPCEvent(reply, this.protoId, destination));
    }

    protected final <V extends ProtoNotification> void subscribeNotification(short nId, NotificationHandler<V> h2) throws HandlerRegistrationException {
        this.registerHandler(nId, h2, this.notificationHandlers);
        babel.subscribeNotification(nId, this);
    }

    protected final void unsubscribeNotification(short nId) {
        this.notificationHandlers.remove(nId);
        babel.unsubscribeNotification(nId, this);
    }

    protected final void triggerNotification(ProtoNotification n) {
        babel.triggerNotification(new NotificationEvent(n, this.protoId));
    }

    protected long setupPeriodicTimer(ProtoTimer timer, long first, long period) {
        return babel.setupPeriodicTimer(timer, this, first, period);
    }

    protected long setupTimer(ProtoTimer t2, long timeout) {
        return babel.setupTimer(t2, this, timeout);
    }

    protected ProtoTimer cancelTimer(long timerID) {
        return babel.cancelTimer(timerID);
    }

    protected final IdentityCrypt generateIdentity() {
        return this.generateIdentity(true);
    }

    protected final IdentityCrypt generateIdentity(boolean persistOnDisk) {
        IdentityCrypt idCrypt = babelSecurity.generateIdentityWithAliasPrefix(persistOnDisk, this.protoName);
        if (this.defaultIdentity == null) {
            this.defaultIdentity = new IdentityPair(idCrypt);
            this.defaultIdentityCrypt = idCrypt;
        }
        return idCrypt;
    }

    protected final IdentityCrypt generateIdentity(String alias) {
        return this.generateIdentity(true, alias);
    }

    protected final IdentityCrypt generateIdentity(boolean persistOnDisk, String alias) {
        IdentityCrypt idCrypt = babelSecurity.generateIdentity(persistOnDisk, alias);
        if (this.defaultIdentity == null && idCrypt != null) {
            this.defaultIdentity = new IdentityPair(idCrypt);
            this.defaultIdentityCrypt = idCrypt;
        }
        return idCrypt;
    }

    protected final IdentityCrypt generateIdentity(KeyPair keyPair) throws NoSuchAlgorithmException {
        return this.generateIdentity(true, keyPair);
    }

    protected final IdentityCrypt generateIdentity(boolean persistOnDisk, KeyPair keyPair) throws NoSuchAlgorithmException {
        IdentityCrypt idCrypt = babelSecurity.generateIdentityWithAliasPrefix(persistOnDisk, this.protoName, keyPair);
        if (this.defaultIdentity == null && idCrypt != null) {
            this.defaultIdentity = new IdentityPair(idCrypt);
            this.defaultIdentityCrypt = idCrypt;
        }
        return idCrypt;
    }

    protected final IdentityCrypt generateIdentity(boolean persistOnDisk, String alias, KeyPair keyPair) throws NoSuchAlgorithmException {
        IdentityCrypt idCrypt = babelSecurity.generateIdentity(persistOnDisk, alias, keyPair);
        if (this.defaultIdentity == null) {
            this.defaultIdentity = new IdentityPair(idCrypt);
            this.defaultIdentityCrypt = idCrypt;
        }
        return idCrypt;
    }

    protected final IdentityPair setDefaultProtoIdentity(String alias) throws NoSuchElementException {
        byte[] id = babelSecurity.getAliasIdentity(alias);
        if (id == null) {
            throw new NoSuchElementException("Couldn't get retreive identity with alias " + alias);
        }
        this.defaultIdentity = new IdentityPair(alias, id);
        this.defaultIdentityCrypt = null;
        return this.defaultIdentity;
    }

    protected final IdentityPair setDefaultProtoIdentity(byte[] identity) throws NoSuchElementException {
        String alias = babelSecurity.getIdentityAlias(identity);
        if (alias == null) {
            throw new NoSuchElementException("Couldn't get retreive identity with id " + PeerIdEncoder.encodeToString(identity));
        }
        this.defaultIdentity = new IdentityPair(alias, identity);
        this.defaultIdentityCrypt = null;
        return this.defaultIdentity;
    }

    protected final IdentityPair getOrGenerateDefaultProtoIdentity() {
        try {
            return this.getDefaultProtoIdentity();
        }
        catch (NoSuchElementException e) {
            this.defaultIdentityCrypt = this.generateIdentity();
            this.defaultIdentity = new IdentityPair(this.defaultIdentityCrypt);
            return this.defaultIdentity;
        }
    }

    protected final IdentityCrypt getDefaultProtoIdentityCrypt() throws NoSuchAlgorithmException, UnrecoverableEntryException, NoSuchElementException {
        if (this.defaultIdentityCrypt == null) {
            this.defaultIdentityCrypt = babelSecurity.getIdentityCrypt(this.getDefaultProtoIdentity().alias());
        }
        return this.defaultIdentityCrypt;
    }

    protected final IdentityPair getDefaultProtoIdentity() throws NoSuchElementException {
        if (this.defaultIdentity == null) {
            this.defaultIdentity = (IdentityPair)babelSecurity.getAllIdentitiesWithPrefix(this.protoName).stream().findAny().orElseThrow(() -> new NoSuchElementException("No protocol identity set. You must choose or create one."));
        }
        return this.defaultIdentity;
    }

    protected final SecretCrypt generateSecretFromPassword(String password) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return this.generateSecretFromPassword(true, password);
    }

    protected final SecretCrypt generateSecretFromPassword(boolean persistOnDisk, String password) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretCrypt secret = babelSecurity.generateSecretFromPasswordWithAliasPrefix(persistOnDisk, this.protoName, password);
        if (this.defaultSecret == null) {
            this.defaultSecret = secret;
        }
        return secret;
    }

    protected final SecretCrypt generateSecretFromPassword(String password, String alias) {
        return this.generateSecretFromPassword(true, password, alias);
    }

    protected final SecretCrypt generateSecretFromPassword(boolean persistOnDisk, String password, String alias) {
        return this.generateSecretFromPassword(persistOnDisk, password, alias);
    }

    protected final SecretCrypt generateSecret() throws NoSuchAlgorithmException {
        return this.generateSecret(true);
    }

    protected final SecretCrypt generateSecret(boolean persistOnDisk) throws NoSuchAlgorithmException {
        SecretCrypt secret = babelSecurity.generateSecretWithAliasPrefix(persistOnDisk, this.protoName);
        if (this.defaultSecret == null) {
            this.defaultSecret = secret;
        }
        return secret;
    }

    protected final SecretCrypt generateSecret(String alias) throws NoSuchAlgorithmException {
        return this.generateSecret(true);
    }

    protected final SecretCrypt generateSecret(boolean persistOnDisk, String alias) throws NoSuchAlgorithmException {
        SecretCrypt secret = babelSecurity.generateSecret(persistOnDisk, alias);
        if (this.defaultSecret == null) {
            this.defaultSecret = secret;
        }
        return secret;
    }

    protected final SecretCrypt addSecret(SecretKey secretKey) throws NoSuchAlgorithmException {
        return this.addSecret(true, secretKey);
    }

    protected final SecretCrypt addSecret(boolean persistOnDisk, SecretKey secretKey) throws NoSuchAlgorithmException {
        SecretCrypt secret = babelSecurity.addSecretWithAliasPrefix(persistOnDisk, this.protoName, secretKey);
        if (this.defaultSecret == null) {
            this.defaultSecret = secret;
        }
        return secret;
    }

    protected final SecretCrypt addSecret(String alias, SecretKey secretKey) throws NoSuchAlgorithmException {
        return this.addSecret(true, alias, secretKey);
    }

    protected final SecretCrypt addSecret(boolean persistOnDisk, String alias, SecretKey secretKey) throws NoSuchAlgorithmException {
        SecretCrypt secret = babelSecurity.addSecret(persistOnDisk, alias, secretKey);
        if (this.defaultSecret == null) {
            this.defaultSecret = secret;
        }
        return secret;
    }

    protected final SecretCrypt setDefaultProtoSecret(String alias) throws NoSuchElementException {
        try {
            SecretCrypt secret = babelSecurity.getSecretCrypt(alias);
            if (secret == null) {
                throw new NoSuchElementException("Couldn't retreive secret with alias " + alias);
            }
            this.defaultSecret = secret;
            return this.defaultSecret;
        }
        catch (NoSuchAlgorithmException | UnrecoverableEntryException e) {
            throw new NoSuchElementException("Couldn't retreive secret with alias " + alias, e);
        }
    }

    protected final SecretCrypt getDefaultProtoSecret() throws NoSuchElementException {
        if (this.defaultSecret == null) {
            throw new NoSuchElementException("Protocol %s has no default secret".formatted(this.protoName));
        }
        return this.defaultSecret;
    }

    void deliverInternalEvent(InternalEvent event) {
        this.queue.add(event);
    }

    private void mainLoop() {
        while (true) {
            try {
                while (true) {
                    InternalEvent internalEvent;
                    InternalEvent pe = this.queue.take();
                    this.metrics_babel.totalEventsCount.inc();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Handling event: " + String.valueOf(pe));
                    }
                    Objects.requireNonNull(pe);
                    int n = 0;
                    block1 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MessageInEvent.class, MessageFailedEvent.class, MessageSentEvent.class, TimerEvent.class, NotificationEvent.class, IPCEvent.class, CustomChannelEvent.class}, (Object)internalEvent, n)) {
                        case 0: {
                            MessageInEvent castPe = (MessageInEvent)internalEvent;
                            this.metrics_babel.messagesInCount.inc();
                            this.handleMessageIn(castPe);
                            break;
                        }
                        case 1: {
                            MessageFailedEvent castPe = (MessageFailedEvent)internalEvent;
                            this.metrics_babel.messagesFailedCount.inc();
                            this.handleMessageFailed(castPe);
                            break;
                        }
                        case 2: {
                            MessageSentEvent castPe = (MessageSentEvent)internalEvent;
                            this.metrics_babel.messagesSentCount.inc();
                            this.handleMessageSent(castPe);
                            break;
                        }
                        case 3: {
                            TimerEvent castPe = (TimerEvent)internalEvent;
                            this.metrics_babel.timersCount.inc();
                            this.handleTimer(castPe);
                            break;
                        }
                        case 4: {
                            NotificationEvent castPe = (NotificationEvent)internalEvent;
                            this.metrics_babel.notificationsCount.inc();
                            this.handleNotification(castPe);
                            break;
                        }
                        case 5: {
                            IPCEvent castPe;
                            IPCEvent i = castPe = (IPCEvent)internalEvent;
                            switch (i.getIpc().getType()) {
                                case REPLY: {
                                    this.metrics_babel.repliesCount.inc();
                                    this.handleReply((ProtoReply)i.getIpc(), i.getSenderID());
                                    break block1;
                                }
                                case REQUEST: {
                                    this.metrics_babel.requestsCount.inc();
                                    this.handleRequest((ProtoRequest)i.getIpc(), i.getSenderID());
                                    break block1;
                                }
                            }
                            throw new AssertionError((Object)"Ups");
                        }
                        case 6: {
                            CustomChannelEvent castPe = (CustomChannelEvent)internalEvent;
                            this.metrics_babel.customChannelEventsCount.inc();
                            this.handleChannelEvent(castPe);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Unexpected event received by babel. protocol " + this.protoId + " (" + this.protoName + ")"));
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("Unhandled exception in protocol " + this.getProtoName() + " (" + this.getProtoId() + ") " + String.valueOf(e), (Throwable)e);
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void handleMessageIn(MessageInEvent m4) {
        BabelMessage msg = m4.getMsg();
        MessageInHandler<? extends ProtoMessage> h2 = this.getChannelOrThrow((int)m4.getChannelId()).messageInHandlers.get(msg.getMessage().getId());
        if (h2 != null) {
            h2.receive(msg.getMessage(), m4.getFrom(), m4.getFromId().orElse(null), msg.getSourceProto(), m4.getChannelId());
        } else {
            logger.warn("Discarding unexpected message (id " + msg.getMessage().getId() + "): " + String.valueOf(m4));
        }
    }

    private void handleMessageFailed(MessageFailedEvent e) {
        BabelMessage msg = e.getMsg();
        MessageFailedHandler<? extends ProtoMessage> h2 = this.getChannelOrThrow((int)e.getChannelId()).messageFailedHandlers.get(msg.getMessage().getId());
        if (h2 != null) {
            h2.onMessageFailed(msg.getMessage(), e.getTo(), e.getToId().orElse(null), msg.getDestProto(), e.getCause(), e.getChannelId());
        } else if (logger.isDebugEnabled()) {
            logger.debug("Discarding unhandled message failed event " + String.valueOf(e));
        }
    }

    private void handleMessageSent(MessageSentEvent e) {
        BabelMessage msg = e.getMsg();
        MessageSentHandler<? extends ProtoMessage> h2 = this.getChannelOrThrow((int)e.getChannelId()).messageSentHandlers.get(msg.getMessage().getId());
        if (h2 != null) {
            h2.onMessageSent(msg.getMessage(), e.getTo(), e.getToId().orElse(null), msg.getDestProto(), e.getChannelId());
        }
    }

    private void handleChannelEvent(CustomChannelEvent m4) {
        ChannelEventHandler<? extends ChannelEvent> h2 = this.getChannelOrThrow((int)m4.getChannelId()).channelEventHandlers.get(m4.getEvent().getId());
        if (h2 != null) {
            h2.handleEvent(m4.getEvent(), m4.getChannelId());
        } else if (logger.isDebugEnabled()) {
            logger.debug("Discarding unhandled channel event (id " + m4.getChannelId() + "): " + String.valueOf(m4));
        }
    }

    private void handleTimer(TimerEvent t2) {
        TimerHandler<? extends ProtoTimer> h2 = this.timerHandlers.get(t2.getTimer().getId());
        if (h2 != null) {
            h2.uponTimer(t2.getTimer().clone(), t2.getUuid());
        } else {
            logger.warn("Discarding unexpected timer (id " + t2.getTimer().getId() + "): " + String.valueOf(t2));
        }
    }

    private void handleNotification(NotificationEvent n) {
        NotificationHandler<? extends ProtoNotification> h2 = this.notificationHandlers.get(n.getNotification().getId());
        if (h2 != null) {
            h2.uponNotification(n.getNotification(), n.getEmitterID());
        } else {
            logger.warn("Discarding unexpected notification (id " + n.getNotification().getId() + "): " + String.valueOf(n));
        }
    }

    private void handleRequest(ProtoRequest r, short from) {
        RequestHandler<? extends ProtoRequest> h2 = this.requestHandlers.get(r.getId());
        if (h2 != null) {
            h2.uponRequest(r, from);
        } else {
            logger.warn("Discarding unexpected request (id " + r.getId() + "): " + String.valueOf(r));
        }
    }

    private void handleReply(ProtoReply r, short from) {
        ReplyHandler<? extends ProtoReply> h2 = this.replyHandlers.get(r.getId());
        if (h2 != null) {
            h2.uponReply(r, from);
        } else {
            logger.warn("Discarding unexpected reply (id " + r.getId() + "): " + String.valueOf(r));
        }
    }

    protected final <T extends Metric<?>> T registerMetric(T m4) {
        MetricsManager.getInstance().registerMetric(m4, this.protoId, this.protoName);
        return m4;
    }

    protected void enableGenericMetrics() {
        this.metrics_babel.registerMetrics();
    }

    public static class ProtocolMetricsBabelMetrics {
        private final Counter totalEventsCount;
        private final Counter messagesInCount;
        private final Counter messagesFailedCount;
        private final Counter messagesSentCount;
        private final Counter timersCount;
        private final Counter notificationsCount;
        private final Counter requestsCount;
        private final Counter repliesCount;
        private final Counter customChannelEventsCount;
        private final short protoId;
        private final String protoName;

        public ProtocolMetricsBabelMetrics(short protoId, String protoName) {
            this.protoId = protoId;
            this.protoName = protoName;
            this.totalEventsCount = new Counter.Builder("babel_events_total", Metric.Unit.NONE, new String[0]).build();
            this.messagesInCount = new Counter.Builder("babel_messages_in_total", Metric.Unit.NONE, new String[0]).build();
            this.messagesFailedCount = new Counter.Builder("babel_messages_failed_total", Metric.Unit.NONE, new String[0]).build();
            this.messagesSentCount = new Counter.Builder("babel_messages_sent_total", Metric.Unit.NONE, new String[0]).build();
            this.timersCount = new Counter.Builder("babel_timers_total", Metric.Unit.NONE, new String[0]).build();
            this.notificationsCount = new Counter.Builder("babel_notifications_total", Metric.Unit.NONE, new String[0]).build();
            this.requestsCount = new Counter.Builder("babel_requests_total", Metric.Unit.NONE, new String[0]).build();
            this.repliesCount = new Counter.Builder("babel_replies_total", Metric.Unit.NONE, new String[0]).build();
            this.customChannelEventsCount = new Counter.Builder("babel_custom_channel_events_total", Metric.Unit.NONE, new String[0]).build();
        }

        public void reset() {
            this.totalEventsCount.reset();
            this.messagesFailedCount.reset();
            this.messagesInCount.reset();
            this.messagesSentCount.reset();
            this.timersCount.reset();
            this.notificationsCount.reset();
            this.repliesCount.reset();
            this.requestsCount.reset();
            this.customChannelEventsCount.reset();
        }

        public void registerMetrics() {
            MetricsManager.getInstance().registerMetric(this.totalEventsCount, this.protoId, this.protoName);
            MetricsManager.getInstance().registerMetric(this.messagesInCount, this.protoId, this.protoName);
            MetricsManager.getInstance().registerMetric(this.messagesFailedCount, this.protoId, this.protoName);
            MetricsManager.getInstance().registerMetric(this.messagesSentCount, this.protoId, this.protoName);
            MetricsManager.getInstance().registerMetric(this.timersCount, this.protoId, this.protoName);
            MetricsManager.getInstance().registerMetric(this.notificationsCount, this.protoId, this.protoName);
            MetricsManager.getInstance().registerMetric(this.requestsCount, this.protoId, this.protoName);
            MetricsManager.getInstance().registerMetric(this.repliesCount, this.protoId, this.protoName);
            MetricsManager.getInstance().registerMetric(this.customChannelEventsCount, this.protoId, this.protoName);
        }
    }

    private static class ChannelHandlers {
        private final Map<Short, MessageInHandler<? extends ProtoMessage>> messageInHandlers = new HashMap<Short, MessageInHandler<? extends ProtoMessage>>();
        private final Map<Short, MessageSentHandler<? extends ProtoMessage>> messageSentHandlers = new HashMap<Short, MessageSentHandler<? extends ProtoMessage>>();
        private final Map<Short, MessageFailedHandler<? extends ProtoMessage>> messageFailedHandlers = new HashMap<Short, MessageFailedHandler<? extends ProtoMessage>>();
        private final Map<Short, ChannelEventHandler<? extends ChannelEvent>> channelEventHandlers = new HashMap<Short, ChannelEventHandler<? extends ChannelEvent>>();
    }
}

