/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.core.adaptive;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.SelfConfigurableProtocol;
import pt.unl.fct.di.novasys.babel.core.adaptive.annotations.Adaptive;
import pt.unl.fct.di.novasys.babel.core.adaptive.messages.ReconfigureMessage;
import pt.unl.fct.di.novasys.babel.core.adaptive.notifications.ReconfigurationFailed;
import pt.unl.fct.di.novasys.babel.core.adaptive.notifications.ReconfigurationSucceeded;
import pt.unl.fct.di.novasys.babel.core.adaptive.requests.GetAdaptiveFieldsReply;
import pt.unl.fct.di.novasys.babel.core.adaptive.requests.GetAdaptiveFieldsRequest;
import pt.unl.fct.di.novasys.babel.core.adaptive.requests.Reconfigure;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.internal.InternalEvent;
import pt.unl.fct.di.novasys.network.data.Host;

public abstract class AdaptiveProtocol
extends SelfConfigurableProtocol {
    private static final Logger logger = LogManager.getLogger(AdaptiveProtocol.class);
    private static final String LOGGER_RECONFIG_REQUEST_TAG = "RECONFIG_REQUEST";
    protected final Map<String, Method> adaptiveSetters = new HashMap<String, Method>();
    private int reconfigurationChannel;

    public AdaptiveProtocol(String protoName, short protoId) throws HandlerRegistrationException {
        super(protoName, protoId);
        this.initialize();
    }

    public AdaptiveProtocol(String protoName, short protoId, BlockingQueue<InternalEvent> policy) throws HandlerRegistrationException {
        super(protoName, protoId, policy);
        this.initialize();
    }

    protected void registerRequestsHandlers() throws HandlerRegistrationException {
        this.registerRequestHandler((short)704, this::uponReconfigureRequest);
        this.registerRequestHandler((short)705, this::uponGetAdaptiveFieldsRequest);
    }

    protected void setReconfigurationChannel(int channelId) throws HandlerRegistrationException {
        this.getChannelOrThrow(channelId);
        this.reconfigurationChannel = channelId;
        this.registerMessageHandler(this.reconfigurationChannel, (short)801, this::uponReconfigureMessage);
        this.registerMessageSerializer(this.reconfigurationChannel, (short)801, ReconfigureMessage.serializer);
    }

    protected void setReconfigurationChannel() throws HandlerRegistrationException {
        this.setReconfigurationChannel(this.getDefaultChannel());
    }

    private void initialize() throws HandlerRegistrationException {
        this.reconfigurationChannel = -1;
        this.registerRequestsHandlers();
        this.assertAndPopulateAdaptiveSetters();
    }

    private final void assertAndPopulateAdaptiveSetters() {
        Field[] fields = this.getClass().getDeclaredFields();
        logger.debug("Checking for adaptive fields in {} ", (Object)this.getClass().getCanonicalName());
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Adaptive.class)) continue;
            logger.debug("Found adaptive field {} of type {}", (Object)field.getName(), (Object)field.getType());
            String setterCanonicalString = this.getCanonicalSetterName(field.getName());
            try {
                Method setter = this.getClass().getDeclaredMethod(setterCanonicalString, AdaptiveProtocol.typeOrWrapper(field.getType()));
                if (!Modifier.isPublic(setter.getModifiers())) {
                    throw new RuntimeException("Adaptive field " + field.getName() + " does not have a public setter method " + setterCanonicalString);
                }
                logger.debug("Adaptive field {} has a public setter with name {}", (Object)field.getName(), (Object)setterCanonicalString);
                this.adaptiveSetters.put(field.getName(), setter);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("No setter method found for adaptive field " + field.getName() + ". Expected method " + setterCanonicalString + " with a single parameter of type " + AdaptiveProtocol.typeOrWrapper(field.getType()).getCanonicalName());
            }
        }
    }

    private void uponReconfigureRequest(Reconfigure request, short protoID) {
        logger.debug("{} {}", (Object)LOGGER_RECONFIG_REQUEST_TAG, (Object)request.getFields());
        logger.trace("Received reconfiguration request: {} from protocol ID {}", (Object)request, (Object)protoID);
        Iterator<Map.Entry<String, Object>> iterator = request.iterator();
        this.handleReconfigurations(iterator);
    }

    private void uponGetAdaptiveFieldsRequest(GetAdaptiveFieldsRequest request, short protoID) {
        GetAdaptiveFieldsReply.GetAdaptiveFieldsReplyBuilder builder = this.getPopulatedAdaptiveFieldBuilder();
        GetAdaptiveFieldsReply reply = builder.build();
        logger.debug("Sending adaptive fields {}", (Object)reply.getFields());
        this.sendReply(reply, protoID);
    }

    protected GetAdaptiveFieldsReply.GetAdaptiveFieldsReplyBuilder getPopulatedAdaptiveFieldBuilder() {
        GetAdaptiveFieldsReply.GetAdaptiveFieldsReplyBuilder builder = new GetAdaptiveFieldsReply.GetAdaptiveFieldsReplyBuilder();
        for (String fieldName : this.adaptiveSetters.keySet()) {
            try {
                Field field = this.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                builder.addField(fieldName, field.get(this));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                logger.error("Error while trying to get value of adaptive field {}", (Object)fieldName, (Object)e);
            }
        }
        return builder;
    }

    private void uponReconfigureMessage(ReconfigureMessage msg, Host from, short sourceProto, int channelId) {
        logger.debug("Received reconfiguration message: {} from protocol ID {}", (Object)msg, (Object)sourceProto);
        Iterator<Map.Entry<String, Object>> iterator = msg.iterator();
        this.handleReconfigurations(iterator);
    }

    public static Class<?> typeOrWrapper(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        return switch (type.getName()) {
            case "boolean" -> Boolean.class;
            case "byte" -> Byte.class;
            case "char" -> Character.class;
            case "double" -> Double.class;
            case "float" -> Float.class;
            case "int" -> Integer.class;
            case "long" -> Long.class;
            case "short" -> Short.class;
            default -> throw new IllegalArgumentException("Unexpected value: " + type.getName());
        };
    }

    private void triggerFailedReconfigNotification(String fieldName, Object value, ReconfigurationFailed.Reason reason, Exception e, Class<?> ... types) {
        String msg = switch (reason) {
            case ReconfigurationFailed.Reason.WRONG_PARAM_TYPE -> "The given value does not match the field " + fieldName + "'s type in " + this.getClass().getCanonicalName() + ". Expected " + types[0].getCanonicalName() + " but got " + types[1].getCanonicalName() + " instead.";
            case ReconfigurationFailed.Reason.NON_ADAPTIVE_FIELD -> "Field " + fieldName + " is not an adaptive field in " + this.getClass().getCanonicalName();
            case ReconfigurationFailed.Reason.UNEXPECTED -> "An unexpected error occurred while trying to reconfigure field " + fieldName + "in " + this.getClass().getCanonicalName();
            default -> null;
        };
        ReconfigurationFailed notification = new ReconfigurationFailed(fieldName, value, msg, e);
        this.triggerNotification(notification);
    }

    private String getCanonicalSetterName(String fieldName) {
        return "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    private void handleReconfigurations(Iterator<Map.Entry<String, Object>> iterator) {
        while (iterator.hasNext()) {
            Map.Entry<String, Object> property = iterator.next();
            String fieldName = property.getKey();
            Object value = property.getValue();
            Class<?> valueType = value.getClass();
            Method setter = this.adaptiveSetters.get(fieldName);
            logger.debug("Trying to reconfigure field {} with value {} in protocol {}", (Object)fieldName, value, (Object)this.getClass().getCanonicalName());
            if (setter == null) {
                this.triggerFailedReconfigNotification(fieldName, value, ReconfigurationFailed.Reason.NON_ADAPTIVE_FIELD, null, new Class[0]);
                continue;
            }
            Class<?>[] paramTypes = setter.getParameterTypes();
            assert (paramTypes.length == 1);
            Class<?> paramType = paramTypes[0];
            if (!paramType.isAssignableFrom(valueType)) {
                this.triggerFailedReconfigNotification(fieldName, value, ReconfigurationFailed.Reason.WRONG_PARAM_TYPE, null, valueType, paramType);
                continue;
            }
            try {
                setter.invoke((Object)this, valueType.cast(value));
                this.triggerNotification(new ReconfigurationSucceeded(fieldName, valueType, this.getClass().getCanonicalName()));
            }
            catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                this.triggerFailedReconfigNotification(fieldName, value, ReconfigurationFailed.Reason.UNEXPECTED, e, valueType, paramType);
            }
        }
    }
}

