/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.core.protocols.discovery;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.DiscoverableProtocol;
import pt.unl.fct.di.novasys.babel.core.protocols.discovery.DiscoveryProtocol;
import pt.unl.fct.di.novasys.babel.core.protocols.discovery.messages.ServiceMessage;
import pt.unl.fct.di.novasys.babel.core.protocols.discovery.requests.FoundServiceReply;
import pt.unl.fct.di.novasys.babel.core.protocols.discovery.requests.RequestDiscovery;
import pt.unl.fct.di.novasys.babel.core.protocols.discovery.timers.AnoucementTimer;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.network.data.Host;

public abstract class LocalDiscoveryProtocol
extends DiscoveryProtocol {
    private static final Logger logger = LogManager.getLogger(LocalDiscoveryProtocol.class);
    public static final int DEFAULT_PORT = 1025;
    public static final int ANOUNCEMENT_COOLDOWN = 1000;
    private DatagramSocket socket;
    private Map<String, ServiceMessage> discoveryProtocolsData;
    private Map<String, DiscoverableProtocol> protocolsWaiting;
    private Map<String, Short> runningProtcolsWaiting;
    private Map<String, DiscoverableProtocol> allDiscoverableProtocols;
    private Host discoveryHost;
    private Set<InetSocketAddress> socketAddresses;
    private Set<ServiceMessage> pendingServices;

    public LocalDiscoveryProtocol(String protoName, short protoId) {
        super(protoName, protoId);
    }

    protected InetAddress getAddressForSocket(Properties props) throws IOException {
        InetAddress address = null;
        if (props.containsKey("babel.discovery.unicast.address")) {
            address = InetAddress.getByName(props.getProperty("babel.discovery.unicast.address"));
        } else if (props.containsKey("babel.discovery.unicast.interface")) {
            Iterator<InterfaceAddress> l = NetworkInterface.getByName(props.getProperty("babel.discovery.unicast.interface")).getInterfaceAddresses().iterator();
            while (l.hasNext() && address == null) {
                InterfaceAddress a = l.next();
                if (a.getAddress() == null || !(a.getAddress() instanceof Inet4Address)) continue;
                address = a.getAddress();
            }
        } else {
            Enumeration<NetworkInterface> iterator = NetworkInterface.getNetworkInterfaces();
            while (iterator.hasMoreElements() && address == null) {
                NetworkInterface n = iterator.nextElement();
                if (n.isLoopback() || n.isVirtual() || !n.isUp() || n.isPointToPoint()) continue;
                for (InterfaceAddress a : n.getInterfaceAddresses()) {
                    if (a.getAddress() == null || !(a.getAddress() instanceof Inet4Address)) continue;
                    address = a.getAddress();
                }
            }
        }
        return address;
    }

    protected InetSocketAddress addInetSocketAddress(InetAddress address, int port) {
        InetSocketAddress socketAddress = new InetSocketAddress(address, port);
        this.socketAddresses.add(socketAddress);
        return socketAddress;
    }

    protected InetSocketAddress addInetSocketAddress(String address, int port) {
        InetSocketAddress socketAddress = new InetSocketAddress(address, port);
        this.socketAddresses.add(socketAddress);
        return socketAddress;
    }

    protected DatagramSocket setSocket(InetAddress address, int port, boolean broadcast) throws SocketException {
        this.socket = new DatagramSocket(port, address);
        this.discoveryHost = new Host(address, port);
        this.socket.setBroadcast(broadcast);
        return this.socket;
    }

    @Override
    public void init(Properties props) throws HandlerRegistrationException, IOException {
        this.discoveryProtocolsData = new ConcurrentHashMap<String, ServiceMessage>();
        this.protocolsWaiting = new ConcurrentHashMap<String, DiscoverableProtocol>();
        this.socketAddresses = new HashSet<InetSocketAddress>();
        this.pendingServices = new HashSet<ServiceMessage>();
        this.runningProtcolsWaiting = new ConcurrentHashMap<String, Short>();
        this.allDiscoverableProtocols = new ConcurrentHashMap<String, DiscoverableProtocol>();
        this.registerTimerHandler((short)32501, this::announce);
        this.setupPeriodicTimer(new AnoucementTimer(), 1000L, 1000L);
    }

    @Override
    public void registerProtocol(DiscoverableProtocol dcProto) {
        this.allDiscoverableProtocols.put(dcProto.getProtoName(), dcProto);
        this.discoveryProtocolsData.put(dcProto.getProtoName(), new ServiceMessage(dcProto.getProtoName(), dcProto.getMyself(), this.discoveryHost, dcProto.isDiscoverable()));
        if (dcProto.needsDiscovery()) {
            logger.debug("Registered protocol " + dcProto.getProtoName());
            this.protocolsWaiting.put(dcProto.getProtoName(), dcProto);
        }
        if (dcProto.readyToStart()) {
            dcProto.start();
            if (!dcProto.hasProtocolThreadStarted()) {
                dcProto.startEventThread();
            }
        }
    }

    private void announce(AnoucementTimer timer, long timerId) {
        logger.info("Firing anouncements");
        if (this.protocolsWaiting.size() == 0 && this.runningProtcolsWaiting.size() == 0) {
            logger.debug("No protocols waiting registered");
            return;
        }
        this.pendingServices.clear();
        for (String protocol : this.protocolsWaiting.keySet()) {
            this.pendingServices.add(this.discoveryProtocolsData.get(protocol));
            logger.debug("Added protocol " + protocol + " to send buffer");
        }
        for (String protocol : this.runningProtcolsWaiting.keySet()) {
            this.pendingServices.add(this.discoveryProtocolsData.get(protocol));
            logger.debug("Added protocol " + protocol + " to send buffer");
        }
        try {
            List<byte[]> announces = ServiceMessage.convertToMessage(this.pendingServices, true);
            for (byte[] m4 : announces) {
                for (InetSocketAddress socketAddress : this.socketAddresses) {
                    logger.debug("Going to send an announce with " + m4.length + " bytes to " + String.valueOf(socketAddress));
                    logger.debug("Sending from socket bounded  (" + this.socket.isBound() + ") to: " + String.valueOf(this.socket.getLocalAddress()) + ":" + this.socket.getLocalPort());
                    this.socket.send(new DatagramPacket(m4, m4.length, socketAddress));
                    logger.debug("Sent one message to " + String.valueOf(socketAddress.getAddress()) + ":" + socketAddress.getPort() + " from " + String.valueOf(this.socket.getLocalAddress()) + ":" + this.socket.getLocalPort());
                }
            }
        }
        catch (Exception e) {
            logger.error("Could not send announcements.");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void listen(DatagramSocket socket) {
        block8: while (true) {
            try {
                while (true) {
                    DatagramPacket packet = new DatagramPacket(new byte[65507], 65507);
                    socket.receive(packet);
                    logger.debug("Discovery has received a message from " + packet.getAddress().getHostAddress() + ":" + packet.getPort() + "on " + (socket instanceof MulticastSocket ? "MulticastSocket" : "UnicastSocket"));
                    if (packet.getAddress().equals(this.socket.getLocalAddress()) && packet.getPort() == this.socket.getLocalPort()) {
                        logger.debug("Discarding multicast packet sent by myself.");
                        continue;
                    }
                    logger.debug("Receive a message with " + packet.getLength() + " bytes.");
                    List<ServiceMessage> messages = ServiceMessage.manyFromDatagram(Arrays.copyOfRange(packet.getData(), 0, packet.getLength()));
                    if (messages.size() > 0) {
                        Object reply;
                        DiscoverableProtocol dp;
                        if (messages.getFirst().isProbe()) {
                            ArrayList<ServiceMessage> replies = new ArrayList<ServiceMessage>();
                            for (ServiceMessage m4 : messages) {
                                dp = this.allDiscoverableProtocols.get(m4.getServiceName());
                                if (dp == null || !dp.isDiscoverable() || (reply = this.discoveryProtocolsData.get(m4.getServiceName())) == null) continue;
                                replies.add((ServiceMessage)reply);
                            }
                            for (byte[] bm : ServiceMessage.convertToMessage(replies, false)) {
                                this.socket.send(new DatagramPacket(bm, bm.length, packet.getAddress(), packet.getPort()));
                            }
                        }
                        Map<String, DiscoverableProtocol> map = this.protocolsWaiting;
                        synchronized (map) {
                            for (ServiceMessage m4 : messages) {
                                Short dpID;
                                dp = null;
                                if (this.protocolsWaiting.size() > 0 && (dp = this.protocolsWaiting.get(m4.getServiceName())) != null) {
                                    reply = dp;
                                    synchronized (reply) {
                                        if (dp.needsDiscovery() && m4.isSenderDiscoverable()) {
                                            dp.addContact(m4.getServiceHost());
                                        }
                                        if (!dp.needsDiscovery()) {
                                            this.protocolsWaiting.remove(m4.getServiceName());
                                        }
                                        if (!dp.hasProtocolThreadStarted() && dp.readyToStart()) {
                                            dp.start();
                                            if (!dp.hasProtocolThreadStarted()) {
                                                dp.startEventThread();
                                            }
                                        }
                                    }
                                }
                                if ((dpID = this.runningProtcolsWaiting.get(m4.getServiceName())) == null || !dp.isDiscoverable()) continue;
                                this.sendReply(new FoundServiceReply(m4.getServiceHost()), dpID);
                            }
                            continue block8;
                        }
                    }
                    logger.warn("Could not deserialize any service message from received datagram.");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    protected boolean hasSocketAddresses() {
        return !this.socketAddresses.isEmpty();
    }

    @Override
    public void uponRequestDiscovery(RequestDiscovery request, short sourceProtocol) {
        logger.debug("Received discovery request for " + request.getServiceName() + " from proto " + sourceProtocol);
        DiscoverableProtocol dp = this.allDiscoverableProtocols.get(request.getProtoName());
        boolean isDiscoverable = true;
        if (dp != null) {
            isDiscoverable = dp.isDiscoverable();
        }
        this.discoveryProtocolsData.put(request.getServiceName(), new ServiceMessage(request.getProtoName(), request.getMyself(), this.discoveryHost, isDiscoverable));
        if (request.getListen()) {
            this.runningProtcolsWaiting.put(request.getServiceName(), sourceProtocol);
        } else {
            this.runningProtcolsWaiting.remove(request.getServiceName());
        }
    }
}

