/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.core.protocols.discovery.messages;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import pt.unl.fct.di.novasys.network.data.Host;

public class ServiceMessage {
    public static final int DATAGRAM_SIZE = 65507;
    public static final byte[] probeID = new byte[]{66, 80, 68, 80};
    public static final byte[] announceID = new byte[]{66, 80, 68, 65};
    private final byte[] id;
    private final String serviceName;
    private final Host serviceHost;
    private final Host discoveryHost;
    private final boolean isDiscoverable;

    public ServiceMessage(String serviceName, Host serviceHost, Host discoveryHost, boolean isDiscoverable) {
        this.id = probeID;
        this.serviceName = serviceName;
        this.serviceHost = serviceHost;
        this.discoveryHost = discoveryHost;
        this.isDiscoverable = isDiscoverable;
    }

    public ServiceMessage(byte[] rid, String serviceName, Host serviceHost, Host discoveryHost, boolean isDiscoverable) throws Exception {
        if (Arrays.compare(rid, probeID) == 0) {
            this.id = probeID;
        } else if (Arrays.compare(rid, announceID) == 0) {
            this.id = announceID;
        } else {
            throw new Exception("Malformed ServiceMessage. No valid identifier: " + String.valueOf(rid));
        }
        this.serviceName = serviceName;
        this.serviceHost = serviceHost;
        this.discoveryHost = discoveryHost;
        this.isDiscoverable = isDiscoverable;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Host getServiceHost() {
        return this.serviceHost;
    }

    public Host getDiscoveryHost() {
        return this.discoveryHost;
    }

    public boolean isSenderDiscoverable() {
        return this.isDiscoverable;
    }

    public boolean isProbe() {
        return this.id == probeID;
    }

    public static byte[] convertToMessage(ServiceMessage m4, boolean asProbe) throws IOException {
        ByteBuf buffer = Unpooled.wrappedBuffer(new byte[65507]);
        buffer.clear();
        if (asProbe) {
            buffer.writeBytes(probeID);
        } else {
            buffer.writeBytes(announceID);
        }
        buffer.writeInt(m4.serviceName.getBytes().length);
        buffer.writeBytes(m4.serviceName.getBytes());
        buffer.writeBoolean(m4.isDiscoverable);
        Host.serializer.serialize(m4.serviceHost, buffer);
        Host.serializer.serialize(m4.discoveryHost, buffer);
        return buffer.capacity(buffer.readableBytes()).array();
    }

    public static ServiceMessage fromDatagram(byte[] data) throws Exception {
        ByteBuf buffer = Unpooled.wrappedBuffer(data);
        buffer.resetReaderIndex();
        byte[] rid = new byte[4];
        buffer.readBytes(rid);
        byte[] serviceName = new byte[buffer.readInt()];
        buffer.readBytes(serviceName);
        boolean discoverable = buffer.readBoolean();
        Host seviceHost = Host.serializer.deserialize(buffer);
        Host discoveryHost = Host.serializer.deserialize(buffer);
        return new ServiceMessage(rid, new String(serviceName), seviceHost, discoveryHost, discoverable);
    }

    public static List<byte[]> convertToMessage(Collection<ServiceMessage> ms, boolean asProbe) throws IOException {
        ByteBuf buffer = Unpooled.wrappedBuffer(new byte[65507]);
        buffer.clear();
        ArrayList<byte[]> messages = new ArrayList<byte[]>(ms.size());
        for (ServiceMessage m4 : ms) {
            byte[] bm = ServiceMessage.convertToMessage(m4, asProbe);
            if (buffer.capacity() - buffer.writerIndex() < 16 + bm.length) {
                messages.add(buffer.capacity(buffer.readableBytes()).array());
                buffer = Unpooled.wrappedBuffer(new byte[65507]);
            }
            buffer.writeShort(Integer.valueOf(bm.length).shortValue());
            buffer.writeBytes(bm);
        }
        if (buffer.isReadable()) {
            messages.add(buffer.capacity(buffer.readableBytes()).array());
        }
        return messages;
    }

    public static List<ServiceMessage> manyFromDatagram(byte[] data) {
        ArrayList<ServiceMessage> messages = new ArrayList<ServiceMessage>();
        ByteBuf buffer = Unpooled.wrappedBuffer(data);
        buffer.resetReaderIndex();
        while (buffer.isReadable()) {
            byte[] msg = new byte[buffer.readShort()];
            buffer.readBytes(msg);
            try {
                messages.add(ServiceMessage.fromDatagram(msg));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return messages;
    }
}

