/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.core.protocols.selfconfigure;

import io.netty.channel.AddressedEnvelope;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DefaultDnsRawRecord;
import io.netty.handler.codec.dns.DefaultDnsRecordDecoder;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.SelfConfigurableProtocol;
import pt.unl.fct.di.novasys.babel.core.protocols.selfconfigure.Parameter;
import pt.unl.fct.di.novasys.babel.core.protocols.selfconfigure.SelfConfigurationProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.network.data.Host;

public class DNSSelfConfigurationProtocol
extends SelfConfigurationProtocol {
    private static final Logger logger = LogManager.getLogger(DNSSelfConfigurationProtocol.class);
    public static final String PROTO_NAME = "BabelDNSSelfConfiguration";
    public static final short PROTO_ID = 32001;
    public static final String PAR_DNS_LOOKUP_SERVER = "dns.lookup.server";
    protected final Map<String, Map<String, Parameter>> protocolToParameterToConfigure = new HashMap<String, Map<String, Parameter>>();
    protected final Set<SelfConfigurableProtocol> protocolSet = new HashSet<SelfConfigurableProtocol>();
    protected DnsNameResolver resolver;
    private String nameserver;
    private Host myself;

    public DNSSelfConfigurationProtocol() {
        super(PROTO_NAME, (short)32001);
    }

    @Override
    public void addProtocolParameterToConfigure(String parameterName, Method setter, Method getter, SelfConfigurableProtocol proto) {
        Parameter parameter = new Parameter(getter, setter, proto, parameterName);
        String protoName = StringUtils.lowerCase(proto.getProtoName());
        String lowerParameterName = StringUtils.lowerCase(parameterName);
        Map<String, Parameter> protocolParameters = this.protocolToParameterToConfigure.get(protoName);
        if (protocolParameters == null) {
            protocolParameters = new HashMap<String, Parameter>();
            this.protocolToParameterToConfigure.put(protoName, protocolParameters);
        }
        protocolParameters.put(lowerParameterName, parameter);
        this.protocolSet.add(proto);
    }

    @Override
    public void addProtocolParameterConfigured(String parameterName, Method setter, Method getter, SelfConfigurableProtocol proto) {
    }

    public Set<SelfConfigurableProtocol> search() {
        try {
            for (SelfConfigurableProtocol proto : this.protocolSet) {
                if (proto.getHost() == null) continue;
                logger.debug("Looking for config at " + proto.getHost());
                DnsResponse results = (DnsResponse)((AddressedEnvelope)this.resolver.query(new DefaultDnsQuestion(proto.getHost(), DnsRecordType.TXT)).get()).content();
                int answerCount = results.count(DnsSection.ANSWER);
                for (int i = 0; i < answerCount; ++i) {
                    Object t2 = results.recordAt(DnsSection.ANSWER, i);
                    if (!(t2 instanceof DefaultDnsRawRecord)) continue;
                    DefaultDnsRawRecord record = (DefaultDnsRawRecord)t2;
                    String[] foundConfig = DefaultDnsRecordDecoder.decodeName(record.content()).split("=");
                    String[] protoNameAndParamName = foundConfig[0].split("\\.");
                    String protoName = StringUtils.lowerCase(protoNameAndParamName[0]);
                    String paramName = StringUtils.lowerCase(protoNameAndParamName[1]);
                    String valueFound = foundConfig[1].split("\\.")[0];
                    logger.debug("Got " + protoName + "." + paramName + "=" + valueFound);
                    Map<String, Parameter> protoParam = this.protocolToParameterToConfigure.get(protoName);
                    Parameter paramToConfigure = protoParam.remove(paramName);
                    paramToConfigure.setter().invoke((Object)paramToConfigure.proto(), valueFound);
                }
                if (!babel.checkAndStartDcProto(proto)) continue;
                this.protocolToParameterToConfigure.remove(StringUtils.lowerCase(proto.getProtoName()));
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Couldn't retrieve DNS record from babel." + this.nameserver);
            e.printStackTrace();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return Collections.unmodifiableSet(this.protocolSet);
    }

    @Override
    public Host getMyself() {
        return this.myself;
    }

    @Override
    public void init(Properties props) throws HandlerRegistrationException, IOException {
        NioEventLoopGroup executor = new NioEventLoopGroup();
        DnsNameResolverBuilder builder = new DnsNameResolverBuilder(executor.next());
        if (props.containsKey(PAR_DNS_LOOKUP_SERVER)) {
            // empty if block
        }
        builder.channelType(NioDatagramChannel.class);
        this.resolver = builder.build();
    }
}

