/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.generic.signed;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.babel.generic.signed.InvalidFormatException;
import pt.unl.fct.di.novasys.babel.generic.signed.InvalidSerializerException;
import pt.unl.fct.di.novasys.babel.generic.signed.NoSignaturePresentException;
import pt.unl.fct.di.novasys.babel.generic.signed.SignedMessageSerializer;

public abstract class SignedProtoMessage
extends ProtoMessage {
    private static final String SignatureAlgorithm = "SHA256withRSA";
    private static final Logger logger = LogManager.getLogger(SignedProtoMessage.class);
    protected byte[] serializedMessage = null;
    protected byte[] signature = null;

    public SignedProtoMessage(short id) {
        super(id);
    }

    public final void signMessage(PrivateKey key) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, InvalidSerializerException {
        if (this.serializedMessage == null) {
            SignedMessageSerializer<? extends SignedProtoMessage> serializer = this.getSerializer();
            if (serializer == null) {
                throw new InvalidSerializerException("No Serializer available for type: " + this.getClass().getCanonicalName() + "\nVerify that the serializer exists and is returned by the method getSerializer()");
            }
            ByteBuf b = Unpooled.buffer();
            b.writeShort(this.getId());
            try {
                serializer.serializeBody(this, b);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.serializedMessage = ByteBufUtil.getBytes(b.slice());
        }
        Signature sig = Signature.getInstance(SignatureAlgorithm);
        sig.initSign(key);
        sig.update(this.serializedMessage);
        this.signature = sig.sign();
    }

    public final boolean checkSignature(PublicKey key) throws InvalidFormatException, NoSignaturePresentException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (this.serializedMessage == null || this.serializedMessage.length == 0) {
            throw new InvalidFormatException("Message serialization format is not present. Was this message received from the network?");
        }
        if (this.signature == null || this.signature.length == 0) {
            throw new NoSignaturePresentException("This message does not contain a signature. Was this message received from the network?");
        }
        Signature sig = Signature.getInstance(SignatureAlgorithm);
        sig.initVerify(key);
        sig.update(this.serializedMessage);
        boolean valid = sig.verify(this.signature);
        if (!valid) {
            logger.debug("Invalid signature on message: <" + this.getClass().getCanonicalName() + "> :: " + this.toString());
        }
        return valid;
    }

    public abstract SignedMessageSerializer<? extends SignedProtoMessage> getSerializer();
}

