/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.internal;

import java.util.Optional;
import pt.unl.fct.di.novasys.babel.internal.BabelMessage;
import pt.unl.fct.di.novasys.babel.internal.InternalEvent;
import pt.unl.fct.di.novasys.babel.internal.security.PeerIdEncoder;
import pt.unl.fct.di.novasys.network.data.Host;

public class MessageSentEvent
extends InternalEvent {
    private final BabelMessage msg;
    private final Host to;
    private final Optional<byte[]> toId;
    private final int channelId;

    public MessageSentEvent(BabelMessage msg, Host to, int channelId) {
        this(msg, to, null, channelId);
    }

    public MessageSentEvent(BabelMessage msg, Host to, byte[] toId, int channelId) {
        super(InternalEvent.EventType.MESSAGE_SENT_EVENT);
        this.msg = msg;
        this.to = to;
        this.toId = Optional.ofNullable(toId);
        this.channelId = channelId;
    }

    public String toString() {
        return "MessageSentEvent{msg=" + String.valueOf(this.msg) + ", to=" + String.valueOf(this.to) + this.toId.map(id -> ", toId=" + PeerIdEncoder.encodeToString(id)).orElse("") + ", channelId=" + this.channelId + "}";
    }

    public final Host getTo() {
        return this.to;
    }

    public final Optional<byte[]> getToId() {
        return this.toId;
    }

    public int getChannelId() {
        return this.channelId;
    }

    public BabelMessage getMsg() {
        return this.msg;
    }
}

