/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics;

import java.util.concurrent.atomic.AtomicLong;
import pt.unl.fct.di.novasys.babel.metrics.Metric;
import pt.unl.fct.di.novasys.babel.metrics.MetricSample;
import pt.unl.fct.di.novasys.babel.metrics.Sample;
import pt.unl.fct.di.novasys.babel.metrics.exceptions.LabeledMetricException;

public class Counter
extends Metric<Counter> {
    private AtomicLong value;

    protected Counter(Builder builder) {
        super(builder);
        if (this.isUnlabeledMetric()) {
            this.value = new AtomicLong();
        }
    }

    private Counter(Metric<Counter> metric) {
        super(metric);
        this.value = new AtomicLong();
    }

    public void inc() {
        this.inc(1L);
    }

    public void inc(long n) {
        if (this.isDisabled()) {
            return;
        }
        if (this.isUnlabeledMetric()) {
            if (n < 0L) {
                throw new IllegalArgumentException("Counter cannot be decremented");
            }
        } else {
            throw new LabeledMetricException();
        }
        this.value.addAndGet(n);
    }

    @Override
    protected void resetThisMetric() {
        this.value.set(0L);
    }

    @Override
    protected Counter newInstance() {
        return new Counter(this);
    }

    @Override
    protected MetricSample collectMetric() {
        return this.sampleBuilder().build(new Sample(this.value.doubleValue()));
    }

    public static class Builder
    extends Metric.MetricBuilder<Builder> {
        public Builder(String name, Metric.Unit unit, String ... labelNames) {
            super(name, unit, Metric.MetricType.COUNTER, labelNames);
        }

        public Builder(String name, String unit, String ... labelNames) {
            super(name, Metric.Unit.of(unit), Metric.MetricType.COUNTER, labelNames);
        }

        @Override
        public Builder self() {
            return this;
        }

        public Counter build() {
            return new Counter(this);
        }
    }
}

