/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics;

import java.util.Arrays;
import pt.unl.fct.di.novasys.babel.metrics.Metric;
import pt.unl.fct.di.novasys.babel.metrics.MetricSample;
import pt.unl.fct.di.novasys.babel.metrics.Sample;
import pt.unl.fct.di.novasys.babel.metrics.exceptions.LabeledMetricException;

public class Histogram
extends Metric<Histogram> {
    private final Object lock = new Object();
    double[] buckets;
    String[] buckets_labels;
    double[] observations_per_bucket;
    double sum;
    double count;
    long time;
    boolean timerStarted = false;
    String[] labelNames = new String[]{"le"};

    protected Histogram(Builder builder) {
        super(builder);
        this.init(builder.buckets, false);
    }

    private Histogram(Metric<Histogram> metric, double[] buckets, String[] bucket_labels) {
        super(metric);
        this.buckets = buckets;
        this.buckets_labels = bucket_labels;
        this.init(buckets, true);
    }

    private void init(double[] buckets, boolean bucketsReady) {
        if (!bucketsReady) {
            this.buckets = new double[buckets.length + 1];
            System.arraycopy(buckets, 0, this.buckets, 0, buckets.length);
            this.buckets[this.buckets.length - 1] = Double.MAX_VALUE;
            this.buckets_labels = new String[this.buckets.length];
            for (int i = 0; i < this.buckets.length - 1; ++i) {
                this.buckets_labels[i] = String.valueOf(buckets[i]);
            }
            this.buckets_labels[this.buckets.length - 1] = "+Inf";
        }
        if (this.isUnlabeledMetric()) {
            this.observations_per_bucket = new double[this.buckets.length];
            this.count = 0.0;
            this.sum = 0.0;
        }
    }

    public void startTimer() {
        if (this.isDisabled()) {
            return;
        }
        if (!this.isUnlabeledMetric()) {
            throw new LabeledMetricException();
        }
        if (this.timerStarted) {
            throw new IllegalStateException("Timer already started");
        }
        this.time = System.nanoTime();
    }

    public void stopTimer() {
        if (this.isDisabled()) {
            return;
        }
        if (!this.isUnlabeledMetric()) {
            throw new LabeledMetricException();
        }
        if (!this.timerStarted) {
            throw new IllegalStateException("Timer not started");
        }
        this.record(System.nanoTime() - this.time);
        this.time = 0L;
        this.timerStarted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(double value) {
        if (this.isDisabled()) {
            return;
        }
        if (this.isUnlabeledMetric()) {
            Object object = this.lock;
            synchronized (object) {
                for (int i = 0; i < this.buckets.length; ++i) {
                    if (!(value <= this.buckets[i])) continue;
                    int n = i;
                    this.observations_per_bucket[n] = this.observations_per_bucket[n] + 1.0;
                    break;
                }
                this.sum += value;
                this.count += 1.0;
            }
        } else {
            throw new LabeledMetricException();
        }
    }

    private Sample[] sampleFromSimpleHistogram(String[] labelNames) {
        double[] observations = this.observations_per_bucket;
        double sum = this.sum;
        double count = this.count;
        Sample[] samples = new Sample[observations.length + 2];
        for (int i = 0; i < observations.length; ++i) {
            samples[i] = new Sample(observations[i], labelNames, new String[]{this.buckets_labels[i]});
        }
        samples[samples.length - 2] = new Sample(sum, labelNames, new String[]{"sum"});
        samples[samples.length - 1] = new Sample(count, labelNames, new String[]{"count"});
        return samples;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void resetThisMetric() {
        Object object = this.lock;
        synchronized (object) {
            Arrays.fill(this.observations_per_bucket, 0.0);
            this.count = 0.0;
            this.sum = 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MetricSample collectMetric() {
        Sample[] samples;
        Object object = this.lock;
        synchronized (object) {
            samples = this.sampleFromSimpleHistogram(this.labelNames);
        }
        return this.sampleBuilder().labelNames(this.labelNames).build(samples);
    }

    @Override
    protected Histogram newInstance() {
        return new Histogram(this, this.buckets, this.buckets_labels);
    }

    public static class Builder
    extends Metric.MetricBuilder<Builder> {
        double[] buckets;

        public Builder(String name, Metric.Unit unit, double[] buckets, String ... labelNames) {
            super(name, unit, Metric.MetricType.HISTOGRAM, labelNames);
            this.buckets = buckets;
        }

        public Builder(String name, String unit, double[] buckets, String ... labelNames) {
            super(name, Metric.Unit.of(unit), Metric.MetricType.HISTOGRAM, labelNames);
            this.buckets = buckets;
        }

        @Override
        public Builder self() {
            return this;
        }

        public Histogram build() {
            return new Histogram(this);
        }
    }
}

