/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.Babel;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.exceptions.ProtocolAlreadyExistsException;
import pt.unl.fct.di.novasys.babel.metrics.Metric;
import pt.unl.fct.di.novasys.babel.metrics.NodeSample;
import pt.unl.fct.di.novasys.babel.metrics.ProtocolMetrics;
import pt.unl.fct.di.novasys.babel.metrics.ProtocolSample;
import pt.unl.fct.di.novasys.babel.metrics.exceptions.DuplicatedProtocolMetric;
import pt.unl.fct.di.novasys.babel.metrics.exceptions.NoProcfsException;
import pt.unl.fct.di.novasys.babel.metrics.exceptions.NoSuchProtocolRegistry;
import pt.unl.fct.di.novasys.babel.metrics.exceptions.OSMetricsConfigException;
import pt.unl.fct.di.novasys.babel.metrics.exporters.Exporter;
import pt.unl.fct.di.novasys.babel.metrics.exporters.ExporterCollectOptions;
import pt.unl.fct.di.novasys.babel.metrics.exporters.MonitorExporter;
import pt.unl.fct.di.novasys.babel.metrics.exporters.ProtocolCollectOptions;
import pt.unl.fct.di.novasys.babel.metrics.exporters.ProtocolExporterHelper;
import pt.unl.fct.di.novasys.babel.metrics.exporters.ThreadedExporter;
import pt.unl.fct.di.novasys.babel.metrics.generic.os.OSMetrics;
import pt.unl.fct.di.novasys.babel.metrics.instant.InstantExporter;
import pt.unl.fct.di.novasys.babel.metrics.monitor.Aggregation;
import pt.unl.fct.di.novasys.babel.metrics.monitor.Monitor;
import pt.unl.fct.di.novasys.babel.metrics.monitor.SimpleMonitor;
import pt.unl.fct.di.novasys.babel.metrics.monitor.datalayer.MonitorStorage;
import pt.unl.fct.di.novasys.babel.metrics.monitor.datalayer.Storage;
import pt.unl.fct.di.novasys.network.data.Host;

public class MetricsManager {
    private static final String CURRENT_WORKING_DIR = System.getProperty("user.dir");
    public static final String GLOBAL_HOST_IDENTIFIER = "GLOBAL";
    public static final short OS_METRIC_PROTOCOL_ID = -1;
    public static final String OS_PROTO_NAME = "OS";
    private static final Logger logger = LogManager.getLogger(MetricsManager.class);
    private final ConcurrentHashMap<Short, ProtocolMetrics> protocolMetricsMap = new ConcurrentHashMap();
    OSMetrics osMetrics;
    List<ThreadedExporter> threadedExporters = new ArrayList<ThreadedExporter>();
    List<InstantExporter> instantExporters = new ArrayList<InstantExporter>();
    List<Exporter> exporters = new ArrayList<Exporter>();
    private boolean disabled = false;
    private SimpleMonitor simpleMonitor;
    Map<Short, Exporter> protocolExporters = new HashMap<Short, Exporter>();
    private static MetricsManager system;
    private boolean started = false;

    public static synchronized MetricsManager getInstance() {
        if (system == null) {
            system = new MetricsManager();
        }
        return system;
    }

    private MetricsManager() {
    }

    public void registerExporters(ThreadedExporter ... exporters) {
        if (this.started) {
            throw new IllegalStateException("Can't register threaded exporters after starting the MetricsManager");
        }
        if (exporters.length == 0) {
            throw new IllegalArgumentException("No exporters provided");
        }
        this.threadedExporters.addAll(Arrays.asList(exporters));
        this.exporters.addAll(Arrays.asList(exporters));
    }

    public void registerExporters(InstantExporter exporter) {
        if (this.started) {
            throw new IllegalStateException("Can't register threaded exporters after starting the MetricsManager");
        }
        this.instantExporters.add(exporter);
    }

    public void registerExporters(ProtocolExporterHelper ... exporters) {
        if (exporters.length == 0) {
            throw new IllegalArgumentException("No exporters provided");
        }
        this.exporters.addAll(Arrays.asList(exporters));
    }

    public synchronized void registerOSMetrics(OSMetrics.MetricType ... metricTypes) throws NoProcfsException, OSMetricsConfigException {
        if (this.osMetrics == null) {
            this.osMetrics = new OSMetrics();
        }
        for (OSMetrics.MetricType mt : metricTypes) {
            try {
                this.registerMetric(this.osMetrics.getOSMetric(mt, this.osMetrics), (short)-1, OS_PROTO_NAME);
            }
            catch (DuplicatedProtocolMetric duplicatedProtocolMetric) {
                // empty catch block
            }
        }
    }

    public synchronized void registerOSMetricCategory(OSMetrics.MetricCategory ... metricCategories) throws NoProcfsException, OSMetricsConfigException {
        if (this.osMetrics == null) {
            this.osMetrics = new OSMetrics();
        }
        Set<OSMetrics.MetricType> mts = this.osMetrics.getMetricsFromCategories(metricCategories);
        this.registerOSMetrics(mts.toArray(new OSMetrics.MetricType[0]));
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        for (ThreadedExporter threadedExporter : this.threadedExporters) {
            new Thread((Runnable)threadedExporter, threadedExporter.getExporterName()).start();
        }
        for (InstantExporter instantExporter : this.instantExporters) {
            new Thread((Runnable)instantExporter, instantExporter.getExporterName()).start();
        }
        this.started = true;
    }

    public synchronized void disable() {
        this.disabled = true;
        for (Exporter ex : this.exporters) {
            ex.disable();
        }
        for (ProtocolMetrics mr : this.protocolMetricsMap.values()) {
            mr.disable();
        }
    }

    public synchronized void registerMetric(Metric m4, short protocolID, String protoName) throws DuplicatedProtocolMetric {
        if (this.disabled) {
            m4.disable();
            return;
        }
        if (this.protocolMetricsMap.containsKey(protocolID)) {
            this.protocolMetricsMap.get(protocolID).register(m4);
        } else {
            ProtocolMetrics pm = new ProtocolMetrics(protocolID, protoName);
            pm.register(m4);
            this.protocolMetricsMap.put(protocolID, pm);
        }
    }

    public NodeSample collectMetricsAllProtocols(ExporterCollectOptions exporterCollectOptions) {
        NodeSample nodeSample = new NodeSample();
        for (Short protocolId : this.protocolMetricsMap.keySet()) {
            if (protocolId == -1 && !exporterCollectOptions.isCollectOSMetrics()) continue;
            nodeSample.addProtocolSample(protocolId, this.collectMetricForProtocol(protocolId, exporterCollectOptions));
        }
        return nodeSample;
    }

    public NodeSample collectMetricsProtocols(boolean collectOSMetrics, ExporterCollectOptions exporterCollectOptions, short ... protocolIds) throws NoSuchProtocolRegistry {
        NodeSample nodeSample = new NodeSample();
        if (collectOSMetrics && this.osMetrics != null) {
            ProtocolSample osSample = this.collectMetricForProtocol((short)-1, exporterCollectOptions);
            nodeSample.addProtocolSample((short)-1, osSample);
        }
        for (short protoId : protocolIds) {
            ProtocolSample protocolSample = this.collectMetricForProtocol(protoId, exporterCollectOptions);
            nodeSample.addProtocolSample(protoId, protocolSample);
        }
        return nodeSample;
    }

    private ProtocolSample collectMetricForProtocol(short protocolId, ExporterCollectOptions exporterCollectOptions) throws NoSuchProtocolRegistry {
        ProtocolMetrics protocolMetrics;
        ProtocolCollectOptions protocolCollectOptions = exporterCollectOptions.getProtocolCollectOptions(protocolId);
        if (protocolCollectOptions == null) {
            protocolCollectOptions = new ProtocolCollectOptions();
        }
        if ((protocolMetrics = this.protocolMetricsMap.get(protocolId)) == null) {
            throw new NoSuchProtocolRegistry(protocolId);
        }
        return protocolMetrics.collect(protocolCollectOptions);
    }

    public String getProtoNameById(short protocolID) {
        if (protocolID == -1) {
            return OS_PROTO_NAME;
        }
        return Babel.getInstance().getProtoNameById(protocolID);
    }

    public void startMonitorExporter(Host self, Host monitor, long interval, ExporterCollectOptions eco) {
        MonitorExporter exporter = new MonitorExporter(self, monitor, interval, eco);
        try {
            Babel.getInstance().registerProtocol(exporter);
            exporter.init(new Properties());
        }
        catch (IOException | HandlerRegistrationException | ProtocolAlreadyExistsException e) {
            throw new RuntimeException(e);
        }
    }

    public Monitor startMonitor(Host myself, Properties props) {
        MonitorStorage monitorStorage = new MonitorStorage(props);
        return this.startMonitor(myself, monitorStorage);
    }

    public Monitor startMonitor(Host myself, Storage storage) {
        if (this.simpleMonitor != null) {
            throw new IllegalStateException("Monitor already started");
        }
        this.simpleMonitor = new SimpleMonitor(myself, storage);
        try {
            Babel.getInstance().registerProtocol(this.simpleMonitor);
            this.simpleMonitor.init(new Properties());
        }
        catch (IOException | HandlerRegistrationException | ProtocolAlreadyExistsException e) {
            throw new RuntimeException(e);
        }
        return this.simpleMonitor;
    }

    public void addAggregation(Aggregation aggregation) {
        this.simpleMonitor.addAggregation(aggregation);
    }
}

