/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import pt.unl.fct.di.novasys.babel.metrics.ProtocolSample;
import pt.unl.fct.di.novasys.babel.metrics.exceptions.NoSuchProtocolRegistry;

public class NodeSample
implements Serializable {
    private final Map<Short, ProtocolSample> samplesPerProtocol;

    public NodeSample() {
        this.samplesPerProtocol = new HashMap<Short, ProtocolSample>();
    }

    public NodeSample(int size) {
        this.samplesPerProtocol = new HashMap<Short, ProtocolSample>(size);
    }

    public void addProtocolSample(short protocolID, ProtocolSample protocolSample) {
        this.samplesPerProtocol.put(protocolID, protocolSample);
    }

    public Set<Short> getProtocols() {
        return this.samplesPerProtocol.keySet();
    }

    public ProtocolSample getProtocolSample(short protocolID) throws NoSuchProtocolRegistry {
        if (!this.samplesPerProtocol.containsKey(protocolID)) {
            throw new NoSuchProtocolRegistry(protocolID);
        }
        return this.samplesPerProtocol.get(protocolID);
    }

    public Map<Short, ProtocolSample> getSamplesPerProtocol() {
        return this.samplesPerProtocol;
    }

    public static NodeSample fromByteArray(byte[] data) {
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));
            return (NodeSample)in.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(this);
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

