/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.metrics;

import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.metrics.Metric;
import pt.unl.fct.di.novasys.babel.metrics.MetricSample;
import pt.unl.fct.di.novasys.babel.metrics.ProtocolSample;
import pt.unl.fct.di.novasys.babel.metrics.exceptions.DuplicatedProtocolMetric;
import pt.unl.fct.di.novasys.babel.metrics.exporters.CollectOptions;
import pt.unl.fct.di.novasys.babel.metrics.exporters.ProtocolCollectOptions;

public class ProtocolMetrics {
    private static final Logger logger = LogManager.getLogger(ProtocolMetrics.class);
    private final short protocolID;
    private final String protocolName;
    private final Map<String, Metric> metrics;

    public ProtocolMetrics(short protocolID, String protoName) {
        this.protocolID = protocolID;
        this.metrics = new ConcurrentHashMap<String, Metric>();
        this.protocolName = protoName;
    }

    public void register(Metric metric) throws DuplicatedProtocolMetric {
        if (this.metrics.containsKey(metric.getName())) {
            throw new DuplicatedProtocolMetric(this.protocolID, metric.getName());
        }
        this.metrics.put(metric.getName(), metric);
    }

    public ProtocolSample collect(ProtocolCollectOptions protocolCollectOptions) {
        LinkedList<MetricSample> samples = new LinkedList<MetricSample>();
        for (Map.Entry<String, Metric> entry : this.metrics.entrySet()) {
            CollectOptions co = protocolCollectOptions.getCollectOptions(entry.getKey());
            if (co == null) {
                logger.debug("Metric {} has no collect options", (Object)entry.getKey());
                co = new CollectOptions();
            }
            logger.debug("Metric {} collect with reset metric: {}", (Object)entry.getKey(), (Object)co.getResetOnCollect());
            samples.add(entry.getValue().collect(co));
        }
        return new ProtocolSample(this.protocolID, this.protocolName, samples);
    }

    public void disable() {
        for (Metric metric : this.metrics.values()) {
            metric.disable();
        }
    }
}

